/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVEnchantment;
import com.starshootercity.version.MVPotionEffectType;
import java.util.Collections;
import java.util.Random;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class Arthropod
implements Ability,
Listener {
    private final Random random = new Random();
    private boolean applySlowness;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:arthropod");
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2.getEquipment() == null) {
                return;
            }
            if (entity2.getEquipment().getItemInMainHand().containsEnchantment(MVEnchantment.BANE_OF_ARTHROPODS.get())) {
                this.runForAbility(event.getEntity(), player -> {
                    int level = entity2.getEquipment().getItemInMainHand().getEnchantmentLevel(MVEnchantment.BANE_OF_ARTHROPODS.get());
                    event.setDamage(event.getDamage() + 1.25 * (double)level);
                    if (this.applySlowness) {
                        player.addPotionEffect(new PotionEffect(MVPotionEffectType.SLOWNESS.get(), (int)(20.0 * this.random.nextDouble(1.0, 1.0 + 0.5 * (double)level)), 3, false, true));
                    }
                });
            }
        }
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.applySlowness = this.registerConfigOption(plugin, "apply_slowness", Collections.singletonList("Apply Slowness when using Bane of Arthropods on players with the Arthropod ability"), ConfigManager.SettingType.BOOLEAN, Boolean.valueOf(true));
    }
}

