/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BurningWrath
implements Listener,
VisibleAbility {
    private int damageIncrease;

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        this.runForAbility(event.getDamager(), player -> {
            if (player.getFireTicks() > 0) {
                event.setDamage(event.getDamage() + (double)this.damageIncrease);
            }
        });
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:burning_wrath");
    }

    @Override
    public String description() {
        return "When on fire, you deal additional damage with your attacks.";
    }

    @Override
    public String title() {
        return "Burning Wrath";
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.damageIncrease = (Integer)this.registerConfigOption(plugin, "damage_increase", Collections.singletonList("How much to increase damage dealt when on fire"), ConfigManager.SettingType.INTEGER, 3);
    }
}

