/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.version.MVPotionEffectType;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class Claustrophobia
implements Listener,
VisibleAbility {
    private final Map<Player, Integer> stacks = new HashMap<Player, Integer>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (player.getLocation().getBlock().getRelative(BlockFace.UP, 2).isSolid()) {
                    this.stacks.put(player, Math.min(this.stacks.getOrDefault(player, -200) + 1, 3600));
                } else {
                    this.stacks.put(player, Math.max(this.stacks.getOrDefault(player, -200) - 1, -200));
                }
                int time = this.stacks.getOrDefault(player, -200);
                if (time > 0) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, time, 0, true, true, true));
                    player.addPotionEffect(new PotionEffect(MVPotionEffectType.SLOWNESS.get(), time, 0, true, true, true));
                }
            });
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() == Material.MILK_BUCKET) {
            this.stacks.put(event.getPlayer(), Math.min(this.stacks.getOrDefault(event.getPlayer(), -200), 0));
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:claustrophobia");
    }

    @Override
    public String description() {
        return "Being somewhere with a low ceiling for too long will weaken you and make you slower.";
    }

    @Override
    public String title() {
        return "Claustrophobia";
    }
}

