/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.ListenerAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Conduit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ConduitPowerOnLand
implements ListenerAbility,
Listener {
    private final PotionEffect conduitPower = new PotionEffect(PotionEffectType.CONDUIT_POWER, 260, 0, true, true, true);
    private final Predicate<Block> isConduit = block -> block.getType().equals((Object)Material.CONDUIT);
    private final String forcedCompatibility = "forced_compatibility";

    @Override
    public boolean shouldRegisterEvents() {
        return (Boolean)this.getConfigOption("forced_compatibility", ConfigManager.SettingType.BOOLEAN) == false;
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:conduit_power_on_land");
    }

    @EventHandler
    public void onServerTickStart(ServerTickStartEvent event) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> OriginsReborn.getMVE().setTouchingWater(player));
        }
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(plugin, "forced_compatibility", List.of("Whether to force compatibility with other abilities", "Less efficient, but prevents it breaking if a player has both this and an ability like origins:water_vulnerability"), ConfigManager.SettingType.BOOLEAN, false);
        if (!((Boolean)this.getConfigOption(plugin, "forced_compatibility", ConfigManager.SettingType.BOOLEAN)).booleanValue()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                HashSet players = new HashSet();
                for (World world : Bukkit.getWorlds()) {
                    for (Chunk chunk : world.getLoadedChunks()) {
                        Collection conduits = chunk.getTileEntities(ConduitPowerOnLand.this.isConduit, true);
                        for (BlockState state : conduits) {
                            int radius = OriginsReborn.getMVE().getConduitRange((Conduit)state);
                            players.addAll(state.getLocation().getNearbyPlayers((double)radius));
                        }
                    }
                }
                for (Player player2 : players.stream().filter(player -> ConduitPowerOnLand.this.hasAbility((Player)player) && !player.isInWater()).toList()) {
                    player2.addPotionEffect(ConduitPowerOnLand.this.conduitPower);
                }
            }
        }.runTaskTimer((Plugin)OriginsReborn.getInstance(), 0L, 20L);
    }
}

