/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class DamageFromSnowballs
implements Ability,
Listener {
    private int damageAmount;
    private boolean knockback;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:damage_from_snowballs");
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntity().getType() != EntityType.SNOWBALL) {
            return;
        }
        this.runForAbility(event.getHitEntity(), player -> {
            OriginsReborn.getMVE().dealFreezeDamage((LivingEntity)player, this.damageAmount);
            Vector vector = event.getEntity().getLocation().getDirection();
            if (this.knockback) {
                OriginsReborn.getMVE().knockback((LivingEntity)player, 0.5, -vector.getX(), -vector.getZ());
            }
        });
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.damageAmount = this.registerConfigOption(plugin, "damage_amount", Collections.singletonList("Amount of damage the player should take when hit with a snowball"), ConfigManager.SettingType.INTEGER, Integer.valueOf(3));
        this.knockback = this.registerConfigOption(plugin, "knockback", Collections.singletonList("Whether snowballs should deal knockback too"), ConfigManager.SettingType.BOOLEAN, Boolean.valueOf(true));
    }
}

