/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.TriggerableAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class LaunchIntoAir
implements Listener,
CooldownAbility,
VisibleAbility,
TriggerableAbility {
    private float launchStrength;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:launch_into_air");
    }

    @Override
    public String description() {
        return "Every 30 seconds, you are able to launch about 20 blocks up into the air.";
    }

    @Override
    public String title() {
        return "Gift of the Winds";
    }

    @Override
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(600, "launch");
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.launchStrength = ((Float)this.registerConfigOption(plugin, "launch_strength", Collections.singletonList("How strong the launch effect should be"), ConfigManager.SettingType.FLOAT, Float.valueOf(2.0f))).floatValue();
    }

    @Override
    @NotNull
    public TriggerableAbility.Trigger getTrigger() {
        return TriggerableAbility.Trigger.builder(TriggerableAbility.TriggerType.SNEAK_ON, this).addConditions(TriggerableAbility.Condition.GLIDING).build(event -> {
            Player player = event.player();
            if (this.hasCooldown(player)) {
                return;
            }
            this.setCooldown(player);
            player.setVelocity(player.getVelocity().add(new Vector(0.0f, this.launchStrength, 0.0f)));
        });
    }
}

