/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.MaterialTags;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class LightArmor
implements Listener,
VisibleAbility {
    private List<Material> allowedTypes;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:light_armor");
    }

    @Override
    public String description() {
        return "You can not wear any heavy armor (armor with protection values higher than chainmail).";
    }

    @Override
    public String title() {
        return "Need for Mobility";
    }

    @EventHandler
    public void onPlayerSwapOrigin(PlayerSwapOriginEvent event) {
        if (event.getNewOrigin() == null) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            ItemStack helmet = event.getPlayer().getInventory().getHelmet();
            ItemStack chestplate = event.getPlayer().getInventory().getChestplate();
            ItemStack leggings = event.getPlayer().getInventory().getLeggings();
            ItemStack boots = event.getPlayer().getInventory().getBoots();
            if (helmet != null && !this.allowedTypes.contains(helmet.getType())) {
                event.getPlayer().getInventory().setHelmet(null);
                ShortcutUtils.giveItemWithDrops(event.getPlayer(), helmet);
            }
            if (chestplate != null && !this.allowedTypes.contains(chestplate.getType())) {
                event.getPlayer().getInventory().setChestplate(null);
                ShortcutUtils.giveItemWithDrops(event.getPlayer(), chestplate);
            }
            if (leggings != null && !this.allowedTypes.contains(leggings.getType())) {
                event.getPlayer().getInventory().setLeggings(null);
                ShortcutUtils.giveItemWithDrops(event.getPlayer(), leggings);
            }
            if (boots != null && !this.allowedTypes.contains(boots.getType())) {
                event.getPlayer().getInventory().setBoots(null);
                ShortcutUtils.giveItemWithDrops(event.getPlayer(), boots);
            }
        });
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity;
        if (event.getInventorySlots().contains(38) && (humanEntity = event.getWhoClicked()) instanceof Player) {
            Player player = (Player)humanEntity;
            this.checkArmorEvent((Cancellable)event, player, event.getOldCursor());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            ItemStack item;
            Player player = (Player)humanEntity;
            if (event.getCursor() != null && this.isArmor(event.getCursor().getType()) && event.getSlotType() == InventoryType.SlotType.ARMOR) {
                this.checkArmorEvent((Cancellable)event, player, event.getCursor());
            }
            if (event.isShiftClick()) {
                if (event.getCurrentItem() == null) {
                    return;
                }
                if (event.getInventory().getType() != InventoryType.CRAFTING) {
                    return;
                }
                if (MaterialTags.HELMETS.isTagged(event.getCurrentItem().getType()) && this.isNull(player.getEquipment().getHelmet())) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
                if (MaterialTags.CHESTPLATES.isTagged(event.getCurrentItem().getType()) && this.isNull(player.getEquipment().getChestplate())) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
                if (MaterialTags.LEGGINGS.isTagged(event.getCurrentItem().getType()) && this.isNull(player.getEquipment().getLeggings())) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
                if (MaterialTags.BOOTS.isTagged(event.getCurrentItem().getType()) && this.isNull(player.getEquipment().getBoots())) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
            }
            if (event.getAction() == InventoryAction.HOTBAR_SWAP && event.getHotbarButton() == -1 && event.getSlotType() == InventoryType.SlotType.ARMOR) {
                this.checkArmorEvent((Cancellable)event, player, player.getInventory().getItemInOffHand());
            }
            if (event.getClick() == ClickType.NUMBER_KEY && event.getSlotType() == InventoryType.SlotType.ARMOR && (item = player.getInventory().getItem(event.getHotbarButton())) != null) {
                this.checkArmorEvent((Cancellable)event, player, item);
            }
        }
    }

    public boolean isNull(ItemStack item) {
        if (item == null) {
            return true;
        }
        return item.getType().isAir();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().isRightClick()) {
            if (event.getItem() == null) {
                return;
            }
            if (MaterialTags.HELMETS.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
            if (MaterialTags.CHESTPLATES.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
            if (MaterialTags.LEGGINGS.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
            if (MaterialTags.BOOTS.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
        }
    }

    @EventHandler
    public void onBlockDispenseArmor(BlockDispenseArmorEvent event) {
        LivingEntity livingEntity = event.getTargetEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.checkArmorEvent((Cancellable)event, player, event.getItem());
        }
    }

    public void checkArmorEvent(Cancellable event, Player p, ItemStack armor) {
        this.runForAbility((Entity)p, player -> {
            if (this.allowedTypes.contains(armor.getType())) {
                return;
            }
            event.setCancelled(true);
        });
    }

    public boolean isArmor(Material material) {
        return MaterialTags.HELMETS.isTagged(material) || MaterialTags.CHESTPLATES.isTagged(material) || MaterialTags.LEGGINGS.isTagged(material) || MaterialTags.BOOTS.isTagged(material);
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.allowedTypes = (List)this.registerConfigOption(plugin, "allowed_armor", Collections.singletonList("Armor allowed to be equipped"), ConfigManager.SettingType.MATERIAL_LIST, List.of(Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS));
    }
}

