/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.TriggerableAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerLeftClickEvent;
import com.starshootercity.util.CustomGUI;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.config.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ShulkerInventory
implements Listener,
VisibleAbility,
TriggerableAbility {
    private NamespacedKey inventoryKey;
    private List<NamespacedKey> keys;
    private boolean dropItemsOnDeath;
    private static File inventories;
    private static FileConfiguration inventoriesConfig;
    private boolean supportLegacyInventoryFile;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:shulker_inventory");
    }

    @Override
    public String description() {
        return "You have access to an additional 9 slots of inventory, which keep the items on death.";
    }

    @Override
    public String title() {
        return "Hoarder";
    }

    @EventHandler
    public void onPlayerLeftClick(PlayerLeftClickEvent event) {
        if (event.hasBlock()) {
            return;
        }
        if (event.hasItem()) {
            return;
        }
        if (ShortcutUtils.isBedrockPlayer(event.getPlayer().getUniqueId())) {
            this.runForAbility((Entity)event.getPlayer(), this::openInventory);
        }
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.registerTranslation("container", "Shulker Inventory");
        this.inventoryKey = new NamespacedKey((Plugin)plugin, "shulker_inventory_contents");
        this.keys = new ArrayList<NamespacedKey>();
        for (int i = 0; i < 9; ++i) {
            this.keys.add(new NamespacedKey((Plugin)plugin, String.valueOf(i)));
        }
        this.dropItemsOnDeath = (Boolean)this.registerConfigOption(plugin, "drop_on_death", Collections.singletonList("Drop items in the inventory on death (will not change ability description, for that edit the translations.yml file)"), ConfigManager.SettingType.BOOLEAN, false);
        this.prepareLegacyInventoryData();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.dropItemsOnDeath) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            PersistentDataContainer pdc = this.getShulkerInventory(player);
            for (NamespacedKey key : pdc.getKeys()) {
                byte[] bytes = (byte[])pdc.get(key, PersistentDataType.BYTE_ARRAY);
                pdc.remove(key);
                if (bytes == null) continue;
                ItemStack item = ItemStack.deserializeBytes((byte[])bytes);
                event.getDrops().add(item);
            }
            this.setShulkerInventory(player, pdc);
        });
    }

    @Override
    @NotNull
    public TriggerableAbility.Trigger getTrigger() {
        return TriggerableAbility.Trigger.builder(TriggerableAbility.TriggerType.RIGHT_CLICK_CHESTPLATE, this).build(event -> {
            event.setCancelled(true);
            this.openInventory(event.player());
        });
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            this.saveInventory(p, event.getInventory());
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            this.saveInventory(p, event.getInventory());
        }
    }

    public void saveInventory(Player p, Inventory inventory) {
        this.runForAbility((Entity)p, player -> Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
            if (inventory.getHolder() instanceof CustomGUI) {
                PersistentDataContainer container = this.getShulkerInventory(player);
                for (int i = 0; i < 9; ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (item == null || item.getType().isAir()) {
                        container.remove(this.keys.get(i));
                        continue;
                    }
                    container.set(this.keys.get(i), PersistentDataType.BYTE_ARRAY, (Object)item.serializeAsBytes());
                }
                this.setShulkerInventory(player, container);
            }
        }));
    }

    public void openInventory(Player player) {
        Inventory inventory = CustomGUI.createInventory(CustomGUI.CustomInventoryType.SHULKER_INVENTORY, InventoryType.DISPENSER, Component.text(this.translate("container")));
        player.openInventory(inventory);
        PersistentDataContainer container = this.getShulkerInventory(player);
        for (int i = 0; i < 9; ++i) {
            if (!container.has(this.keys.get(i), PersistentDataType.BYTE_ARRAY)) continue;
            byte[] bytes = (byte[])container.get(this.keys.get(i), PersistentDataType.BYTE_ARRAY);
            ItemStack item = ItemStack.deserializeBytes((byte[])bytes);
            inventory.setItem(i, item);
        }
    }

    public PersistentDataContainer getShulkerInventory(Player player) {
        PersistentDataContainer container = (PersistentDataContainer)player.getPersistentDataContainer().get(this.inventoryKey, PersistentDataType.TAG_CONTAINER);
        if (container == null) {
            container = player.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer();
        }
        return container;
    }

    public void setShulkerInventory(Player player, PersistentDataContainer container) {
        player.getPersistentDataContainer().set(this.inventoryKey, PersistentDataType.TAG_CONTAINER, (Object)container);
    }

    private void prepareLegacyInventoryData() {
        inventories = new File(OriginsReborn.getInstance().getDataFolder(), "internals/inventories.yml");
        this.supportLegacyInventoryFile = inventories.exists();
        if (!this.supportLegacyInventoryFile) {
            return;
        }
        inventoriesConfig = new YamlConfiguration();
        try {
            inventoriesConfig.load(inventories);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) throws IOException {
        if (!this.supportLegacyInventoryFile) {
            return;
        }
        if (!inventoriesConfig.contains(event.getPlayer().getUniqueId().toString())) {
            return;
        }
        PersistentDataContainer container = this.getShulkerInventory(event.getPlayer());
        for (int i = 0; i < 9; ++i) {
            ItemStack item;
            String path = "%s.%s".formatted(event.getPlayer().getUniqueId().toString(), i);
            if (!inventoriesConfig.contains(path) || (item = inventoriesConfig.getItemStack(path)) == null) continue;
            container.set(this.keys.get(i), PersistentDataType.BYTE_ARRAY, (Object)item.serializeAsBytes());
        }
        this.setShulkerInventory(event.getPlayer(), container);
        inventoriesConfig.set(event.getPlayer().getUniqueId().toString(), null);
        inventoriesConfig.save(inventories);
        if (inventoriesConfig.getKeys(false).isEmpty()) {
            boolean ignored = inventories.delete();
            this.supportLegacyInventoryFile = false;
            inventoriesConfig = null;
            inventories = null;
        }
    }
}

