/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.TriggerableAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.cooldowns.Cooldowns;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ThrowEnderPearl
implements Listener,
CooldownAbility,
VisibleAbility,
TriggerableAbility {
    private final NamespacedKey falseEnderPearlKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "false-ender-pearl");

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:throw_ender_pearl");
    }

    @Override
    public String description() {
        return "Whenever you want, you may throw an ender pearl which deals no damage, allowing you to teleport.";
    }

    @Override
    public String title() {
        return "Teleportation";
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntity().getPersistentDataContainer().has(this.falseEnderPearlKey, PersistentDataType.STRING)) {
            event.setCancelled(true);
            String name = (String)event.getEntity().getPersistentDataContainer().get(this.falseEnderPearlKey, PersistentDataType.STRING);
            if (name == null) {
                return;
            }
            Player player = Bukkit.getPlayer((String)name);
            if (player == null) {
                return;
            }
            Location loc = event.getEntity().getLocation();
            loc.setPitch(player.getLocation().getPitch());
            loc.setYaw(player.getLocation().getYaw());
            player.setFallDistance(0.0f);
            player.setVelocity(new Vector());
            player.teleport(loc);
            event.getEntity().remove();
        }
    }

    @Override
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(30, "ender_pearl");
    }

    @Override
    @NotNull
    public TriggerableAbility.Trigger getTrigger() {
        return TriggerableAbility.Trigger.builder(TriggerableAbility.TriggerType.LEFT_CLICK, this).addConditions(TriggerableAbility.Condition.EMPTY_HAND, TriggerableAbility.Condition.NO_BLOCK).build(event -> {
            Player player = event.player();
            if (this.hasCooldown(player)) {
                return;
            }
            this.setCooldown(player);
            Projectile projectile = player.launchProjectile(EnderPearl.class);
            projectile.getPersistentDataContainer().set(this.falseEnderPearlKey, PersistentDataType.STRING, (Object)player.getName());
        });
    }
}

