/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class WaterVulnerability
implements Listener,
VisibleAbility {
    private final Map<Player, Integer> lastWaterDamagedMap = new HashMap<Player, Integer>();
    private int damageAmount;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:water_vulnerability");
    }

    @Override
    public String description() {
        return "You receive damage over time while in contact with water.";
    }

    @Override
    public String title() {
        return "Hydrophobia";
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (Bukkit.getCurrentTick() - this.lastWaterDamagedMap.getOrDefault(player, Bukkit.getCurrentTick() - 20) < 20) {
                    return;
                }
                if (player.isInWaterOrRainOrBubbleColumn() || OriginsReborn.getMVE().wasTouchingWater(player)) {
                    OriginsReborn.getMVE().dealFreezeDamage((LivingEntity)player, this.damageAmount);
                    this.lastWaterDamagedMap.put(player, Bukkit.getCurrentTick());
                }
            });
        }
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.damageAmount = (Integer)this.registerConfigOption(plugin, "damage_amount", Collections.singletonList("Amount of damage to take in water"), ConfigManager.SettingType.INTEGER, 1);
    }
}

