/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.SavedPotionEffect;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVAttribute;
import com.starshootercity.version.MVPotionEffectType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class WeakArms
implements Listener,
VisibleAbility {
    private List<Material> naturalStones;
    private final Map<Player, SavedPotionEffect> storedEffects = new HashMap<Player, SavedPotionEffect>();
    private final NamespacedKey key = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "break-speed-modifier");

    @Override
    public void initialize(JavaPlugin plugin) {
        this.naturalStones = (List)this.registerConfigOption(plugin, "natural_stones", Collections.singletonList("Blocks that count as natural stone"), ConfigManager.SettingType.MATERIAL_LIST, List.of(Material.STONE, Material.TUFF, Material.GRANITE, Material.DIORITE, Material.ANDESITE, Material.SANDSTONE, Material.SMOOTH_SANDSTONE, Material.RED_SANDSTONE, Material.SMOOTH_RED_SANDSTONE, Material.DEEPSLATE, Material.BLACKSTONE, Material.NETHERRACK));
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        Attribute attribute = MVAttribute.BLOCK_BREAK_SPEED.get();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                Block target = player.getTargetBlockExact(8, FluidCollisionMode.NEVER);
                PotionEffect strength = player.getPotionEffect(MVPotionEffectType.STRENGTH.get());
                int sides = 0;
                if (target != null && this.naturalStones.contains(target.getType())) {
                    if (this.naturalStones.contains(target.getRelative(BlockFace.DOWN).getType())) {
                        ++sides;
                    }
                    if (this.naturalStones.contains(target.getRelative(BlockFace.UP).getType())) {
                        ++sides;
                    }
                    if (this.naturalStones.contains(target.getRelative(BlockFace.WEST).getType())) {
                        ++sides;
                    }
                    if (this.naturalStones.contains(target.getRelative(BlockFace.EAST).getType())) {
                        ++sides;
                    }
                    if (this.naturalStones.contains(target.getRelative(BlockFace.NORTH).getType())) {
                        ++sides;
                    }
                    if (this.naturalStones.contains(target.getRelative(BlockFace.SOUTH).getType())) {
                        ++sides;
                    }
                }
                if (sides > 2 && strength == null && this.naturalStones.contains(target.getType())) {
                    if (attribute == null) {
                        PotionEffect effect = player.getPotionEffect(MVPotionEffectType.MINING_FATIGUE.get());
                        boolean ambient = false;
                        boolean showParticles = false;
                        if (effect != null) {
                            ambient = effect.isAmbient();
                            showParticles = effect.hasParticles();
                            if (effect.getAmplifier() != -1) {
                                this.storedEffects.put(player, new SavedPotionEffect(effect, Bukkit.getCurrentTick()));
                                player.removePotionEffect(MVPotionEffectType.MINING_FATIGUE.get());
                            }
                        }
                        player.addPotionEffect(new PotionEffect(MVPotionEffectType.MINING_FATIGUE.get(), ShortcutUtils.infiniteDuration(), -1, ambient, showParticles));
                    } else {
                        AttributeInstance instance = player.getAttribute(attribute);
                        if (instance == null) {
                            return;
                        }
                        if (OriginsReborn.getMVE().getAttributeModifier(instance, (Key)this.key) == null) {
                            OriginsReborn.getMVE().addAttributeModifier(instance, this.key, "weak-arms", -1.0, AttributeModifier.Operation.ADD_NUMBER);
                        }
                    }
                } else if (attribute == null) {
                    Object effect;
                    if (player.hasPotionEffect(MVPotionEffectType.MINING_FATIGUE.get()) && (effect = player.getPotionEffect(MVPotionEffectType.MINING_FATIGUE.get())) != null && effect.getAmplifier() == -1) {
                        player.removePotionEffect(MVPotionEffectType.MINING_FATIGUE.get());
                    }
                    if (this.storedEffects.containsKey(player)) {
                        effect = this.storedEffects.get(player);
                        this.storedEffects.remove(player);
                        PotionEffect potionEffect = ((SavedPotionEffect)effect).effect();
                        int time = potionEffect.getDuration() - (Bukkit.getCurrentTick() - ((SavedPotionEffect)effect).currentTime());
                        if (time > 0) {
                            player.addPotionEffect(new PotionEffect(potionEffect.getType(), time, potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles()));
                        }
                    }
                } else {
                    AttributeInstance instance = player.getAttribute(attribute);
                    if (instance == null) {
                        return;
                    }
                    AttributeModifier attributeModifier = OriginsReborn.getMVE().getAttributeModifier(instance, (Key)this.key);
                    if (attributeModifier == null) {
                        return;
                    }
                    instance.removeModifier(attributeModifier);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() == Material.MILK_BUCKET) {
            this.storedEffects.remove(event.getPlayer());
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:weak_arms");
    }

    @Override
    public String description() {
        return "When not under the effect of a strength potion, you can only mine natural stone if there are at most 2 other natural stone blocks adjacent to it.";
    }

    @Override
    public String title() {
        return "Weak Arms";
    }
}

