/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.starshootercity.APITarget;
import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsAddon;
import com.starshootercity.OriginsReborn;
import com.starshootercity.Translator;
import com.starshootercity.abilities.types.DependantAbility;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.WorldGuardHook;
import com.starshootercity.util.config.ConfigManager;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@APITarget
public interface Ability {
    @NotNull
    public Key getKey();

    @NotNull
    default public Key getRegisteredKey() {
        return AbilityRegister.invertedAbilityMap.get(this);
    }

    default public void runForAbility(Entity entity, @NotNull AbilityRunner runner) {
        this.runForAbility(entity, runner, (AbilityRunner)null);
    }

    default public void runForAbility(Entity entity, @Nullable AbilityRunner has, @Nullable AbilityRunner other) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.hasAbility(player)) {
                if (has != null) {
                    has.run(player);
                }
            } else if (other != null) {
                other.run(player);
            }
        }
    }

    default public void runForAbility(Entity entity, @Nullable AbilityRunner has, @Nullable Runnable other) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.hasAbility(player)) {
                if (has != null) {
                    has.run(player);
                }
            } else if (other != null) {
                other.run();
            }
        } else if (other != null) {
            other.run();
        }
    }

    default public boolean hasAbility(Player player) {
        if (AbilityRegister.disabledWorlds.contains(player.getWorld().getName())) {
            return false;
        }
        for (OriginsAddon.KeyStateGetter keyStateGetter : AddonLoader.abilityOverrideChecks) {
            OriginsAddon.State state = keyStateGetter.get(player, this.getRegisteredKey());
            if (state == OriginsAddon.State.DENY) {
                return false;
            }
            if (state != OriginsAddon.State.ALLOW) continue;
            return true;
        }
        if (OriginsReborn.isWorldGuardHookInitialized()) {
            if (WorldGuardHook.isAbilityDisabled(player.getLocation(), this)) {
                return false;
            }
            ConfigurationSection section = OriginsReborn.getInstance().getConfig().getConfigurationSection("prevent-abilities-in");
            com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)player.getLocation());
            if (section != null) {
                RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
                RegionQuery query = container.createQuery();
                ApplicableRegionSet set = query.getApplicableRegions(loc);
                for (ProtectedRegion region : set) {
                    for (String sectionKey : section.getKeys(false)) {
                        if (!section.getStringList(sectionKey).contains(this.getRegisteredKey().toString()) && !section.getStringList(sectionKey).contains("all") || !region.getId().equalsIgnoreCase(sectionKey)) continue;
                        return false;
                    }
                }
            }
        }
        List<Origin> origins = OriginSwapper.getOrigins(player);
        boolean hasAbility = origins.stream().anyMatch(origin -> origin.hasAbility(this));
        Ability ability = AbilityRegister.abilityMap.get(this.getRegisteredKey());
        if (ability instanceof DependantAbility) {
            DependantAbility dependantAbility = (DependantAbility)ability;
            return hasAbility && dependantAbility.getDependencyType() == DependantAbility.DependencyType.REGULAR == dependantAbility.getDependency().isEnabled(player);
        }
        return hasAbility;
    }

    default public void initialize(JavaPlugin plugin) {
    }

    default public void registerTranslation(String key, String def) {
        Translator.registerTranslation("abilities." + String.valueOf(this.getRegisteredKey()) + "." + key, def);
    }

    default public String translate(String key) {
        return Translator.translate("abilities." + String.valueOf(this.getRegisteredKey()) + "." + key);
    }

    default public <T> T registerConfigOption(JavaPlugin plugin, String path, List<String> comments, ConfigManager.SettingType<T> settingType, T defaultValue) {
        AbilityRegister.registerConfigOption(plugin, this, settingType, path, comments, defaultValue);
        return this.getConfigOption(plugin, path, settingType);
    }

    default public <T> void registerConfigOption(String path, List<String> comments, ConfigManager.SettingType<T> settingType, T defaultValue) {
        this.registerConfigOption(AbilityRegister.pluginMap.get(this.getRegisteredKey()), path, comments, settingType, defaultValue);
    }

    default public <T> T getConfigOption(JavaPlugin plugin, String path, ConfigManager.SettingType<T> settingType) {
        return AbilityRegister.getConfigOption(plugin, this, settingType, path);
    }

    @Deprecated(forRemoval=true)
    default public <T> T getConfigOption(OriginsAddon addon, String path, ConfigManager.SettingType<T> settingType) {
        return AbilityRegister.getConfigOption(addon, this, settingType, path);
    }

    @Deprecated(forRemoval=true)
    default public <T> void registerConfigOption(OriginsAddon addon, String path, List<String> comments, ConfigManager.SettingType<T> settingType, T defaultValue) {
        AbilityRegister.registerConfigOption(addon, this, settingType, path, comments, defaultValue);
    }

    default public <T> T getConfigOption(String path, ConfigManager.SettingType<T> settingType) {
        return this.getConfigOption(AbilityRegister.pluginMap.get(this.getRegisteredKey()), path, settingType);
    }

    public static interface AbilityRunner {
        public void run(Player var1);
    }
}

