/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.APITarget;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.SavedPotionEffect;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.version.MVAttribute;
import com.starshootercity.version.MVBlockDamageAbortEvent;
import com.starshootercity.version.MVEnchantment;
import com.starshootercity.version.MVPotionEffectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@APITarget
public interface BreakSpeedModifierAbility
extends Ability {
    public static final NamespacedKey key = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "break-speed-modifier");

    public BlockMiningContext getMiningContext(Player var1);

    public boolean shouldActivate(Player var1);

    private static boolean isTool(Material material) {
        return MaterialTags.PICKAXES.isTagged(material) || MaterialTags.AXES.isTagged(material) || MaterialTags.SWORDS.isTagged(material) || MaterialTags.SHOVELS.isTagged(material) || MaterialTags.HOES.isTagged(material) || material == Material.SHEARS || material == Material.TRIDENT;
    }

    public static class ModifiedBlockBreakEvent
    extends BlockBreakEvent {
        public ModifiedBlockBreakEvent(@NotNull Block theBlock, @NotNull Player player) {
            super(theBlock, player);
        }
    }

    public static class BreakSpeedModifierAbilityListener
    implements Listener {
        Random random = new Random();
        private final Map<Integer, Entity> taskEntityMap = new HashMap<Integer, Entity>();
        private final Map<Integer, Player> taskPlayerMap = new HashMap<Integer, Player>();
        private final Map<Integer, Block> taskBlockMap = new HashMap<Integer, Block>();
        private final Map<Player, Integer> blockbreakingTasks = new HashMap<Player, Integer>();
        Map<Player, SavedPotionEffect> storedEffects = new HashMap<Player, SavedPotionEffect>();

        @EventHandler
        public void onBlockDamage(final BlockDamageEvent event) {
            if (event.getBlock().getType().getHardness() < 0.0f) {
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
                BreakSpeedModifierAbility speedModifierAbility = null;
                for (BreakSpeedModifierAbility ability : AbilityRegister.breakSpeedModifierAbilities) {
                    if (!ability.hasAbility(event.getPlayer()) || !ability.shouldActivate(event.getPlayer())) continue;
                    speedModifierAbility = ability;
                    break;
                }
                if (speedModifierAbility == null) {
                    return;
                }
                AtomicInteger time = new AtomicInteger();
                Entity marker = event.getPlayer().getWorld().spawnEntity(event.getPlayer().getLocation(), EntityType.MARKER);
                BreakSpeedModifierAbility finalSpeedModifierAbility = speedModifierAbility;
                int task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)OriginsReborn.getInstance(), () -> {
                    try {
                        BlockMiningContext context = finalSpeedModifierAbility.getMiningContext(event.getPlayer());
                        float damage = BreakSpeedModifierAbilityListener.getBlockDamage(event.getBlock(), context, time.getAndIncrement());
                        if (damage >= 1.0f) {
                            int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                            this.cancelTask(taskNum);
                            ModifiedBlockBreakEvent blockBreakEvent = new ModifiedBlockBreakEvent(event.getBlock(), event.getPlayer());
                            blockBreakEvent.callEvent();
                            ItemStack handItem = event.getPlayer().getInventory().getItemInMainHand();
                            if (BreakSpeedModifierAbility.isTool(handItem.getType())) {
                                ItemMeta patt0$temp;
                                int unbreakingLevel = handItem.getEnchantmentLevel(MVEnchantment.UNBREAKING.get()) + 1;
                                int itemDamage = 0;
                                if (this.random.nextDouble() <= 1.0 / (double)unbreakingLevel) {
                                    ++itemDamage;
                                }
                                if (event.getBlock().getDrops(context.heldItem()).isEmpty() && this.random.nextDouble() <= 1.0 / (double)unbreakingLevel) {
                                    ++itemDamage;
                                }
                                if ((patt0$temp = handItem.getItemMeta()) instanceof Damageable) {
                                    Damageable damageable = (Damageable)patt0$temp;
                                    damageable.setDamage(damageable.getDamage() + itemDamage);
                                    if (handItem.getType().getMaxDurability() <= damageable.getDamage()) {
                                        OriginsReborn.getMVE().broadcastSlotBreak(event.getPlayer(), EquipmentSlot.HAND, (Collection<Player>)new ArrayList<Player>(){
                                            {
                                                for (Player player : Bukkit.getOnlinePlayers()) {
                                                    if (player.getWorld() != event.getPlayer().getWorld() || !(player.getLocation().distance(event.getPlayer().getLocation()) < 32.0)) continue;
                                                    this.add(player);
                                                }
                                            }
                                        });
                                        event.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                                    } else {
                                        handItem.setItemMeta((ItemMeta)damageable);
                                    }
                                }
                            }
                            if (!blockBreakEvent.isCancelled()) {
                                event.getBlock().breakNaturally(event.getPlayer().getInventory().getItemInMainHand(), true);
                            }
                            return;
                        }
                        OriginsReborn.getMVE().sendBlockDamage(event.getPlayer(), event.getBlock().getLocation(), damage, marker);
                        Block target = event.getPlayer().getTargetBlockExact(8, FluidCollisionMode.NEVER);
                        if (target == null || !target.getLocation().equals((Object)event.getBlock().getLocation())) {
                            int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                            this.cancelTask(taskNum);
                        }
                    }
                    catch (NullPointerException e) {
                        int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                        this.cancelTask(taskNum);
                    }
                }, 1L, 0L);
                if (this.blockbreakingTasks.containsKey(event.getPlayer())) {
                    this.cancelTask(this.blockbreakingTasks.get(event.getPlayer()));
                    this.blockbreakingTasks.remove(event.getPlayer());
                }
                this.blockbreakingTasks.put(event.getPlayer(), task);
                this.taskEntityMap.put(task, marker);
                this.taskBlockMap.put(task, event.getBlock());
                this.taskPlayerMap.put(task, event.getPlayer());
            });
        }

        private void cancelTask(int task) {
            Bukkit.getScheduler().cancelTask(task);
            Entity marker = this.taskEntityMap.get(task);
            Player player = this.taskPlayerMap.get(task);
            if (player != null && marker != null) {
                OriginsReborn.getMVE().sendBlockDamage(player, this.taskBlockMap.get(task).getLocation(), 0.0f, marker);
                marker.remove();
            }
            this.taskEntityMap.remove(task);
            this.taskBlockMap.remove(task);
            this.taskPlayerMap.remove(task);
        }

        private static float getBlockDamage(Block block, BlockMiningContext context, int time) {
            return (float)(Math.round(BreakSpeedModifierAbilityListener.getDestroySpeed(context, block.getType()) * (float)time * 1000.0f) / 1000) / (float)(block.getDrops(context.heldItem()).isEmpty() ? 100 : 30);
        }

        public static float getDestroySpeed(BlockMiningContext context, Material blockType) {
            ItemStack itemstack;
            int i;
            float f = OriginsReborn.getMVE().getDestroySpeed(context.heldItem(), blockType);
            if (f > 1.0f && (i = (itemstack = context.heldItem()).getEnchantmentLevel(MVEnchantment.EFFICIENCY.get())) > 0 && itemstack.getType() != Material.AIR) {
                f += (float)(i * i + 1);
            }
            if (context.hasDigSpeed()) {
                f *= 1.0f + (float)(context.getDigSpeedAmplification() + 1) * 0.2f;
            }
            if (context.hasDigSlowdown()) {
                int digSlowdown = context.getDigSlowdown();
                float f1 = switch (digSlowdown) {
                    case 0 -> 0.3f;
                    case 1 -> 0.09f;
                    case 2 -> 0.0027f;
                    default -> 1.0f;
                };
                f *= f1;
            }
            if (context.underwater() && !context.aquaAffinity()) {
                f /= 5.0f;
            }
            if (!context.onGround()) {
                f /= 5.0f;
            }
            float d = OriginsReborn.getMVE().getDestroySpeed(blockType);
            return f / d;
        }

        @EventHandler
        public void onBlockDamage(MVBlockDamageAbortEvent event) {
            if (this.blockbreakingTasks.containsKey(event.getPlayer())) {
                int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                this.cancelTask(taskNum);
            }
        }

        @EventHandler
        public void onServerTickEnd(ServerTickEndEvent event) {
            Attribute attribute = MVAttribute.BLOCK_BREAK_SPEED.get();
            for (Player player : Bukkit.getOnlinePlayers()) {
                AttributeModifier attributeModifier;
                List<Origin> origins = OriginSwapper.getOrigins(player);
                ArrayList<Ability> abilities = new ArrayList<Ability>();
                for (Origin origin : origins) {
                    abilities.addAll(origin.getAbilities());
                }
                BreakSpeedModifierAbility speedModifierAbility = null;
                for (Ability ability : abilities) {
                    BreakSpeedModifierAbility modifierAbility;
                    if (!(ability instanceof BreakSpeedModifierAbility) || !(modifierAbility = (BreakSpeedModifierAbility)ability).shouldActivate(player)) continue;
                    speedModifierAbility = modifierAbility;
                    break;
                }
                if (speedModifierAbility != null) {
                    if (attribute == null) {
                        PotionEffect potionEffect = player.getPotionEffect(MVPotionEffectType.MINING_FATIGUE.get());
                        boolean ambient = false;
                        boolean showParticles = false;
                        if (potionEffect != null) {
                            ambient = potionEffect.isAmbient();
                            showParticles = potionEffect.hasParticles();
                            if (potionEffect.getAmplifier() != -1) {
                                this.storedEffects.put(player, new SavedPotionEffect(potionEffect, Bukkit.getCurrentTick()));
                                player.removePotionEffect(MVPotionEffectType.MINING_FATIGUE.get());
                            }
                        }
                        player.addPotionEffect(new PotionEffect(MVPotionEffectType.MINING_FATIGUE.get(), ShortcutUtils.infiniteDuration(), -1, ambient, showParticles));
                        continue;
                    }
                    AttributeInstance attributeInstance = player.getAttribute(attribute);
                    if (attributeInstance == null || OriginsReborn.getMVE().getAttributeModifier(attributeInstance, (Key)key) != null) continue;
                    OriginsReborn.getMVE().addAttributeModifier(attributeInstance, key, "break-speed-modifier", -1.0, AttributeModifier.Operation.ADD_NUMBER);
                    continue;
                }
                if (attribute == null) {
                    PotionEffect potionEffect;
                    if (player.hasPotionEffect(MVPotionEffectType.MINING_FATIGUE.get()) && (potionEffect = player.getPotionEffect(MVPotionEffectType.MINING_FATIGUE.get())) != null && potionEffect.getAmplifier() == -1) {
                        player.removePotionEffect(MVPotionEffectType.MINING_FATIGUE.get());
                    }
                    if (!this.storedEffects.containsKey(player)) continue;
                    SavedPotionEffect savedPotionEffect = this.storedEffects.get(player);
                    this.storedEffects.remove(player);
                    PotionEffect potionEffect2 = savedPotionEffect.effect();
                    int time = potionEffect2.getDuration() - (Bukkit.getCurrentTick() - savedPotionEffect.currentTime());
                    if (time <= 0) continue;
                    player.addPotionEffect(new PotionEffect(potionEffect2.getType(), time, potionEffect2.getAmplifier(), potionEffect2.isAmbient(), potionEffect2.hasParticles()));
                    continue;
                }
                AttributeInstance attributeInstance = player.getAttribute(attribute);
                if (attributeInstance == null || (attributeModifier = OriginsReborn.getMVE().getAttributeModifier(attributeInstance, (Key)key)) == null) continue;
                attributeInstance.removeModifier(attributeModifier);
            }
        }
    }

    public record BlockMiningContext(ItemStack heldItem, @Nullable PotionEffect slowDigging, @Nullable PotionEffect fastDigging, @Nullable PotionEffect conduitPower, boolean underwater, boolean aquaAffinity, boolean onGround) {
        public boolean hasDigSpeed() {
            return this.fastDigging != null || this.conduitPower != null;
        }

        public boolean hasDigSlowdown() {
            return this.slowDigging != null;
        }

        public int getDigSlowdown() {
            if (this.slowDigging == null) {
                return 0;
            }
            return this.slowDigging.getAmplifier();
        }

        public int getDigSpeedAmplification() {
            int i = 0;
            int j = 0;
            if (this.fastDigging != null) {
                i = this.fastDigging.getAmplifier();
            }
            if (this.conduitPower != null) {
                j = this.conduitPower.getAmplifier();
            }
            return Math.max(i, j);
        }
    }
}

