/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.starshootercity.APITarget;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@APITarget
public interface CooldownAbility
extends Ability {
    public static final String COOLDOWN = "cooldown-duration";

    default public NamespacedKey getCooldownKey() {
        return new NamespacedKey((Plugin)OriginsReborn.getInstance(), this.getRegisteredKey().asString().replace(":", "-"));
    }

    default public void setCooldown(Player player) {
        if (ConfigManager.getConfigValue(ConfigManager.Option.DISABLE_ALL_COOLDOWNS).booleanValue()) {
            return;
        }
        OriginsReborn.getCooldowns().setCooldown(player, this.getCooldownKey());
    }

    default public void setCooldown(Player player, int amount) {
        if (ConfigManager.getConfigValue(ConfigManager.Option.DISABLE_ALL_COOLDOWNS).booleanValue()) {
            return;
        }
        OriginsReborn.getCooldowns().setCooldown(player, this.getCooldownKey(), amount);
    }

    default public boolean hasCooldown(Player player) {
        if (ConfigManager.getConfigValue(ConfigManager.Option.DISABLE_ALL_COOLDOWNS).booleanValue()) {
            return false;
        }
        return OriginsReborn.getCooldowns().hasCooldown(player, this.getCooldownKey());
    }

    default public long getCooldown(Player player) {
        return OriginsReborn.getCooldowns().getCooldown(player, this.getCooldownKey());
    }

    public Cooldowns.CooldownInfo getCooldownInfo();

    default public void setupCooldownConfig(JavaPlugin instance) {
        Cooldowns.CooldownInfo info = this.getCooldownInfo();
        if (!info.isStatic()) {
            int i = this.registerConfigOption(instance, COOLDOWN, Collections.singletonList("The duration of the cooldown (in ticks)"), ConfigManager.SettingType.INTEGER, Integer.valueOf(info.getCooldownTime()));
            info.setCooldownTime(i);
        }
        OriginsReborn.getCooldowns().registerCooldown(instance, this.getCooldownKey(), info);
    }
}

