/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.APITarget;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.Ability;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@APITarget
public interface ParticleAbility
extends Ability {
    public Particle getParticle();

    default public int getFrequency() {
        return 4;
    }

    default public int getExtra() {
        return 0;
    }

    default public Object getData() {
        return null;
    }

    public static class ParticleAbilityListener
    implements Listener {
        @EventHandler
        public void onServerTickEnd(ServerTickEndEvent event) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
                List<Origin> origins = OriginSwapper.getOrigins(player);
                ArrayList<Ability> abilities = new ArrayList<Ability>();
                for (Origin origin : origins) {
                    abilities.addAll(origin.getAbilities());
                }
                for (Ability ability : abilities) {
                    if (!(ability instanceof ParticleAbility)) continue;
                    ParticleAbility particleAbility = (ParticleAbility)ability;
                    if (event.getTickNumber() % particleAbility.getFrequency() != 0) continue;
                    player.getWorld().spawnParticle(particleAbility.getParticle(), player.getLocation(), 1, 0.5, 1.0, 0.5, (double)particleAbility.getExtra(), particleAbility.getData());
                }
            }
        }
    }
}

