/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.starshootercity.APITarget;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.Ability;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@APITarget
public interface VisibleAbility
extends Ability {
    @ApiStatus.Internal
    default public void setupTranslatedText() {
        this.registerTranslation("title", this.title());
        this.registerTranslation("description", this.description());
    }

    @NotNull
    default public List<OriginSwapper.LineData.LineComponent> getDescription() {
        if (!this.useTranslator()) {
            return OriginSwapper.LineData.makeLineFor(this.description(), OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        }
        String value = this.translate("description");
        try {
            value = this.modifyDescription(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return OriginSwapper.LineData.makeLineFor(value, OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    public String description();

    @NotNull
    default public List<OriginSwapper.LineData.LineComponent> getTitle() {
        if (!this.useTranslator()) {
            return OriginSwapper.LineData.makeLineFor(this.title(), OriginSwapper.LineData.LineComponent.LineType.TITLE);
        }
        String value = this.translate("title");
        try {
            value = this.modifyDescription(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return OriginSwapper.LineData.makeLineFor(value, OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    public String title();

    default public String modifyDescription(String description) {
        return description;
    }

    default public String modifyTitle(String title) {
        return title;
    }

    default public boolean useTranslator() {
        return true;
    }
}

