/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.commands;

import com.starshootercity.AddonLoader;
import com.starshootercity.OrbOfOrigin;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.PackApplier;
import com.starshootercity.Translator;
import com.starshootercity.commands.DiscordCommand;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.CompressionUtils;
import com.starshootercity.util.config.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginCommand
implements CommandExecutor,
TabCompleter {
    public static NamespacedKey key;
    private final Map<Player, List<ExchangeRequest>> exchangeRequests = new HashMap<Player, List<ExchangeRequest>>();

    public static void initialize() {
        Translator.registerTranslation("command.no_swap_permission", "\u00a7cYou don't have permission to do this!");
        key = OriginsReborn.getCooldowns().registerCooldown(OriginsReborn.getInstance(), new NamespacedKey((Plugin)OriginsReborn.getInstance(), "swap-command-cooldown"), new Cooldowns.CooldownInfo(0));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            sender.sendMessage(Component.text("Invalid command. Usage: /origin <command>").color(NamedTextColor.RED));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "swap": {
                Player targetPlayer;
                if (!ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_ENABLED).booleanValue()) {
                    sender.sendMessage(Component.text("This command has been disabled in the configuration").color(NamedTextColor.RED));
                    return true;
                }
                if (args.length == 3) {
                    if (!sender.hasPermission("originsreborn.admin")) {
                        sender.sendMessage((Component)Component.text(Translator.translate("command.no_swap_permission")));
                        return true;
                    }
                    targetPlayer = Bukkit.getPlayer((String)args[2]);
                    if (targetPlayer == null) {
                        sender.sendMessage(Component.text("Invalid player name").color(NamedTextColor.RED));
                        return true;
                    }
                } else if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!AddonLoader.allowOriginSwapCommand(player)) {
                        sender.sendMessage((Component)Component.text(Translator.translate("command.no_swap_permission")));
                        return true;
                    }
                    targetPlayer = player;
                    if (OriginsReborn.getCooldowns().hasCooldown(player, key)) {
                        player.sendMessage(Component.text("You are on cooldown.").color(NamedTextColor.RED));
                        return true;
                    }
                } else {
                    sender.sendMessage(Component.text("You must specify a player!").color(NamedTextColor.RED));
                    return true;
                }
                String layer = args.length >= 2 ? args[1] : "origin";
                targetPlayer.getPersistentDataContainer().set(OriginSwapper.awaitingOriginChangeKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
                OriginSwapper.openOriginSwapper(targetPlayer, PlayerSwapOriginEvent.SwapReason.COMMAND, 0, 0, OriginsReborn.getInstance().isVaultEnabled(), layer);
                return true;
            }
            case "reload": {
                Player player;
                if (sender instanceof Player && !(player = (Player)sender).hasPermission("originsreborn.admin")) {
                    sender.sendMessage(Component.text("You don't have permission to do this!").color(NamedTextColor.RED));
                    return true;
                }
                try {
                    AddonLoader.reloadAddons();
                    OriginsReborn.getInstance().reloadConfig();
                    AbilityRegister.reloadAbilityConfig();
                    Translator.reloadTranslations();
                    sender.sendMessage(Component.text("Reload complete. Note that a full server restart may be required for some features.").color(NamedTextColor.GREEN));
                }
                catch (Throwable t) {
                    sender.sendMessage(Component.text("An unknown error occurred.").color(NamedTextColor.RED));
                }
                return true;
            }
            case "exchange": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (sender.hasPermission("originsreborn.exchange")) {
                        if (args.length < 2) {
                            sender.sendMessage(Component.text("Usage: /origin exchange <player> [<layer>]").color(NamedTextColor.RED));
                            return true;
                        }
                        Player target = Bukkit.getPlayer((String)args[1]);
                        if (target == null) {
                            sender.sendMessage(Component.text("Usage: /origin exchange <player> [<layer>]").color(NamedTextColor.RED));
                            return true;
                        }
                        if (target.equals((Object)player)) {
                            sender.sendMessage(Component.text("You must specify another player.").color(NamedTextColor.RED));
                            return true;
                        }
                        for (ExchangeRequest request2 : this.exchangeRequests.getOrDefault(player, List.of())) {
                            if (request2.expireTime > Bukkit.getCurrentTick()) continue;
                            String l = request2.layer.substring(0, 0).toUpperCase() + request2.layer.substring(1);
                            String layer = request2.layer;
                            if (!request2.p2.equals((Object)player) || !request2.p1.equals((Object)target)) continue;
                            target.sendMessage(Component.text("%s swapped with %s.".formatted(l, player.getName())).color(NamedTextColor.AQUA));
                            player.sendMessage(Component.text("%s swapped with %s.".formatted(l, target.getName())).color(NamedTextColor.AQUA));
                            Origin pOrigin = OriginSwapper.getOrigin(player, layer);
                            Origin tOrigin = OriginSwapper.getOrigin(target, layer);
                            OriginSwapper.setOrigin(player, tOrigin, PlayerSwapOriginEvent.SwapReason.COMMAND, false, layer);
                            OriginSwapper.setOrigin(target, pOrigin, PlayerSwapOriginEvent.SwapReason.COMMAND, false, layer);
                            return true;
                        }
                        if (!this.exchangeRequests.containsKey(target)) {
                            this.exchangeRequests.put(target, new ArrayList());
                        }
                        this.exchangeRequests.get(target).removeIf(request -> request.p1.equals((Object)player) && request.p2.equals((Object)player));
                        String layer = args.length != 3 ? "origin" : args[2];
                        this.exchangeRequests.get(target).add(new ExchangeRequest(player, target, Bukkit.getCurrentTick() + 6000, layer));
                        target.sendMessage(Component.text("%s is requesting to swap %s with you, type /origin exchange %s to accept. The request will expire in 5 minutes.".formatted(layer, player.getName(), player.getName())).color(NamedTextColor.AQUA));
                        player.sendMessage(Component.text("Requesting to swap %s with %s. The request will expire in 5 minutes.".formatted(layer, target.getName())).color(NamedTextColor.AQUA));
                    } else {
                        sender.sendMessage(Component.text("You don't have permission to do this!").color(NamedTextColor.RED));
                    }
                } else {
                    sender.sendMessage(Component.text("Only players can switch origins with others!").color(NamedTextColor.RED));
                }
                return true;
            }
            case "set": {
                Player player;
                if (sender instanceof Player && !(player = (Player)sender).hasPermission("originsreborn.admin")) {
                    sender.sendMessage(Component.text("You don't have permission to do this!").color(NamedTextColor.RED));
                    return true;
                }
                if (args.length < 4) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin set <player> <layer> <origin>").color(NamedTextColor.RED));
                    return true;
                }
                String layer = args[2];
                Player player2 = Bukkit.getPlayer((String)args[1]);
                if (player2 == null) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin set <player> <layer> <origin>").color(NamedTextColor.RED));
                    return true;
                }
                Origin origin = AddonLoader.getOrigin(args[3].replace("_", " "));
                if (origin == null || !origin.getLayer().equals(layer)) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin set <player> <layer> <origin>").color(NamedTextColor.RED));
                    return true;
                }
                OriginSwapper.setOrigin(player2, origin, PlayerSwapOriginEvent.SwapReason.COMMAND, false, layer);
                return true;
            }
            case "clear": {
                Player player;
                if (sender instanceof Player && !(player = (Player)sender).hasPermission("originsreborn.admin")) {
                    sender.sendMessage(Component.text("You don't have permission to do this!").color(NamedTextColor.RED));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin clear <player> <layer>").color(NamedTextColor.RED));
                    return true;
                }
                String layer = args[2];
                Player player3 = Bukkit.getPlayer((String)args[1]);
                if (player3 == null) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin clear <player> <layer>").color(NamedTextColor.RED));
                    return true;
                }
                OriginSwapper.setOrigin(player3, null, PlayerSwapOriginEvent.SwapReason.COMMAND, false, layer);
                return true;
            }
            case "orb": {
                Player player = null;
                if (args.length == 2) {
                    player = Bukkit.getPlayer((String)args[1]);
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    if (player == null) {
                        player = p;
                    }
                    if (!p.hasPermission("originsreborn.admin")) {
                        sender.sendMessage(Component.text("You don't have permission to do this!").color(NamedTextColor.RED));
                        return true;
                    }
                } else if (player == null) {
                    sender.sendMessage(Component.text("This command can only be run by a player").color(NamedTextColor.RED));
                    return true;
                }
                player.getInventory().addItem(new ItemStack[]{OrbOfOrigin.orb});
                return true;
            }
            case "check": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    String layer = args.length >= 2 ? args[1] : "origin";
                    Origin origin = args.length >= 3 ? AddonLoader.getOrigin(args[2].replace("_", " ")) : OriginSwapper.getOrigin(player, layer);
                    if (origin == null) {
                        return true;
                    }
                    OriginSwapper.openOriginSwapper(player, PlayerSwapOriginEvent.SwapReason.COMMAND, AddonLoader.getOrigins(layer).indexOf(origin), 0, false, true, layer);
                } else {
                    sender.sendMessage(Component.text("This command can only be run by a player").color(NamedTextColor.RED));
                }
                return true;
            }
            case "pack": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    PackApplier.sendPacks(player);
                } else {
                    sender.sendMessage(Component.text("This command can only be run by a player").color(NamedTextColor.RED));
                }
                return true;
            }
            case "export": {
                if (args.length != 3) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin export <addon id> <path>").color(NamedTextColor.RED));
                    return true;
                }
                File output = new File(OriginsReborn.getInstance().getDataFolder(), "export/" + args[2] + ".orbarch");
                List<File> files = AddonLoader.originFiles.get(args[1]);
                if (files == null) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin export <addon id> <path>").color(NamedTextColor.RED));
                    return true;
                }
                try {
                    CompressionUtils.compressFiles(files, output);
                    sender.sendMessage(Component.text("Exported origins to '~/plugins/Origins-Reborn/export/%s.orbarch'".formatted(args[2])).color(NamedTextColor.AQUA));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
            case "discord": {
                DiscordCommand.sendURL(sender);
                return true;
            }
            case "import": {
                if (args.length != 2) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin import <path>").color(NamedTextColor.RED));
                    return true;
                }
                File input = new File(OriginsReborn.getInstance().getDataFolder(), "import/" + args[1]);
                File output = new File(OriginsReborn.getInstance().getDataFolder(), "origins");
                if (!input.exists() || !output.exists()) {
                    sender.sendMessage(Component.text("Invalid command. Usage: /origin import <path>").color(NamedTextColor.RED));
                    return true;
                }
                try {
                    CompressionUtils.decompressFiles(input, output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        }
        sender.sendMessage(Component.text("Invalid command. Usage: /origin <command>").color(NamedTextColor.RED));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            args = new String[]{""};
        }
        ArrayList<String> result = new ArrayList<String>();
        List data = switch (args.length) {
            case 1 -> {
                Player player;
                Object r = new ArrayList();
                r.add("check");
                if (sender instanceof Player && AddonLoader.allowOriginSwapCommand(player = (Player)sender)) {
                    r.add("swap");
                }
                if (sender.hasPermission("originsreborn.exchange")) {
                    r.add("exchange");
                }
                if (!sender.hasPermission("originsreborn.admin")) {
                    yield r;
                }
                r.add("reload");
                r.add("set");
                r.add("orb");
                r.add("export");
                r.add("import");
                r.add("pack");
                r.add("clear");
                r.add("discord");
                yield r;
            }
            case 2 -> {
                switch (args[0]) {
                    case "set": 
                    case "orb": 
                    case "exchange": 
                    case "clear": {
                        yield new ArrayList<String>(){
                            {
                                for (Player player : Bukkit.getOnlinePlayers()) {
                                    this.add(player.getName());
                                }
                            }
                        };
                    }
                    case "export": {
                        yield new ArrayList<String>(AddonLoader.originFiles.keySet());
                    }
                    case "check": 
                    case "swap": {
                        yield new ArrayList<String>(AddonLoader.layers);
                    }
                    case "import": {
                        File input = new File(OriginsReborn.getInstance().getDataFolder(), "import");
                        File[] files = input.listFiles();
                        if (files == null) {
                            yield List.of();
                        }
                        ArrayList<String> fileNames = new ArrayList<String>();
                        for (File file : files) {
                            fileNames.add(file.getName());
                        }
                        yield fileNames;
                    }
                }
                yield List.of();
            }
            case 3 -> {
                String layer;
                if (Set.of("set", "clear").contains(args[0])) {
                    yield AddonLoader.layers;
                }
                if (args[0].equals("check")) {
                    layer = args[1];
                    yield new ArrayList<String>(){
                        {
                            for (Origin origin : AddonLoader.getOrigins(layer)) {
                                this.add(origin.getName().toLowerCase().replace(" ", "_"));
                            }
                        }
                    };
                }
                if (args[0].equals("swap")) {
                    yield new ArrayList<String>(){
                        {
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                this.add(player.getName());
                            }
                        }
                    };
                }
                yield List.of();
            }
            case 4 -> {
                String layer;
                if (args[0].equals("set")) {
                    layer = args[2];
                    yield new ArrayList<String>(){
                        {
                            for (Origin origin : AddonLoader.getOrigins(layer)) {
                                this.add(origin.getName().toLowerCase().replace(" ", "_"));
                            }
                        }
                    };
                }
                yield List.of();
            }
            default -> List.of();
        };
        StringUtil.copyPartialMatches((String)args[args.length - 1], data, result);
        return result;
    }

    public record ExchangeRequest(Player p1, Player p2, int expireTime, String layer) {
    }
}

