/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.geysermc;

import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.commands.OriginCommand;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.VaultHook;
import com.starshootercity.util.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.geyser.api.GeyserApi;

public class GeyserSwapper {
    private static final Random random = new Random();

    public static boolean checkBedrockSwap(Player player, PlayerSwapOriginEvent.SwapReason reason, boolean cost, boolean displayOnly, String layer) {
        try {
            if (!ShortcutUtils.isBedrockPlayer(player.getUniqueId())) {
                return true;
            }
            GeyserSwapper.openOriginSwapper(player, reason, displayOnly, cost, layer);
            return false;
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, boolean displayOnly, boolean cost, String layer) {
        ArrayList<Origin> origins = new ArrayList<Origin>(AddonLoader.getOrigins(layer));
        if (displayOnly) {
            Origin origin2 = OriginSwapper.getOrigin(player, layer);
            if (origin2 != null) {
                GeyserSwapper.openOriginInfo(player, origin2, PlayerSwapOriginEvent.SwapReason.COMMAND, true, false, layer);
            }
            return;
        }
        origins.removeIf(origin -> origin.isUnchoosable(player) || origin.hasPermission() && !player.hasPermission(origin.getPermission()));
        origins.sort((o1, o2) -> {
            if (o1.getImpact() == o2.getImpact()) {
                if (o1.getPosition() == o2.getPosition()) {
                    return 0;
                }
                return o1.getPosition() > o2.getPosition() ? 1 : -1;
            }
            return o1.getImpact() > o2.getImpact() ? 1 : -1;
        });
        SimpleForm.Builder form = (SimpleForm.Builder)SimpleForm.builder().title("Choose your Origin");
        for (Origin origin3 : origins) {
            if (origin3.getIcon().getType() == Material.PLAYER_HEAD) {
                form.button(origin3.getName(), FormImage.Type.URL, "https://mc-heads.net/avatar/MHF_Steve");
                continue;
            }
            form.button(origin3.getName(), FormImage.Type.URL, origin3.getResourceURL());
        }
        boolean enableRandom = ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_RANDOM_OPTION_ENABLED);
        if (enableRandom) {
            form.button("Random", FormImage.Type.URL, "https://static.wikia.nocookie.net/origins-smp/images/1/13/Origin_Orb.png/revision/latest?cb=20210411202749");
        }
        GeyserSwapper.sendForm(player.getUniqueId(), ((SimpleForm.Builder)((SimpleForm.Builder)form.closedOrInvalidResultHandler(() -> {
            if (OriginSwapper.getOrigin(player, layer) == null) {
                GeyserSwapper.openOriginSwapper(player, reason, false, cost, layer);
            }
        })).validResultHandler(response -> GeyserSwapper.openOriginInfo(player, AddonLoader.getOrigin(response.clickedButton().text().toLowerCase()), reason, false, cost, layer))).build());
    }

    private static void sendForm(UUID uuid, Form form) {
        try {
            FloodgateApi.getInstance().sendForm(uuid, form);
        }
        catch (NoClassDefFoundError e) {
            GeyserApi.api().sendForm(uuid, form);
        }
    }

    public static void setOrigin(Player player, Origin origin, PlayerSwapOriginEvent.SwapReason reason, boolean cost, String layer) {
        if (OriginsReborn.getInstance().isVaultEnabled() && cost) {
            int amount = ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_DEFAULT_COST);
            if (origin.getCost() != null) {
                amount = origin.getCost();
            }
            if (VaultHook.has(player, amount)) {
                VaultHook.withdraw(player, amount);
            } else {
                String symbol = ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_CURRENCY_SYMBOL);
                player.sendMessage((Component)Component.text("You need %s%s to swap your origin!".formatted(symbol, amount)));
                return;
            }
        }
        if (reason == PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN) {
            OriginSwapper.orbCooldown.put(player, System.currentTimeMillis());
        }
        boolean resetPlayer = OriginSwapper.shouldResetPlayer(reason);
        if (origin == null) {
            ArrayList<Origin> origins = new ArrayList<Origin>(AddonLoader.getOrigins(layer));
            origins.removeIf(origin1 -> origin1.isUnchoosable(player));
            List<String> excludedOrigins = ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_RANDOM_OPTION_EXCLUDE);
            origins.removeIf(possibleOrigin -> excludedOrigins.contains(possibleOrigin.getName()));
            origin = (Origin)origins.get(random.nextInt(origins.size()));
        }
        if (reason == PlayerSwapOriginEvent.SwapReason.COMMAND) {
            OriginsReborn.getCooldowns().setCooldown(player, OriginCommand.key, ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_COOLDOWN));
        }
        OriginSwapper.setOrigin(player, origin, reason, resetPlayer, layer);
    }

    public static void openOriginInfo(Player player, Origin origin, PlayerSwapOriginEvent.SwapReason reason, boolean displayOnly, boolean cost, String layer) {
        ModalForm.Builder form = ModalForm.builder();
        StringBuilder info = new StringBuilder();
        if (origin != null) {
            form.title(origin.getName());
            for (OriginSwapper.LineData.LineComponent line : new OriginSwapper.LineData(origin).getRawLines()) {
                if (line.isEmpty()) {
                    info.append("\n\n");
                } else {
                    info.append(line.getRawText());
                }
                if (line.getType() != OriginSwapper.LineData.LineComponent.LineType.TITLE) continue;
                info.append("\n");
            }
        } else {
            form.title("Random Origin");
            ArrayList<Origin> origins = new ArrayList<Origin>(AddonLoader.getOrigins(layer));
            origins.removeIf(origin1 -> origin1.isUnchoosable(player));
            List<String> excludedOrigins = ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_RANDOM_OPTION_EXCLUDE);
            info.append("You'll be assigned one of the following:\n\n");
            for (Origin possibleOrigin : origins) {
                if (excludedOrigins.contains(possibleOrigin.getName())) continue;
                info.append(possibleOrigin.getName()).append("\n");
            }
        }
        if (cost) {
            String symbol = ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_CURRENCY_SYMBOL);
            int amount = ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_DEFAULT_COST);
            if (origin != null && origin.getCost() != null) {
                amount = origin.getCost();
            }
            info.append("\n\n\n\u00a7eThis will cost you %s%s!".formatted(symbol, amount));
        }
        form.content(info.toString());
        form.button1("Cancel");
        form.button2("Confirm");
        GeyserSwapper.sendForm(player.getUniqueId(), ((ModalForm.Builder)((ModalForm.Builder)form.closedOrInvalidResultHandler(() -> {
            if (!displayOnly) {
                GeyserSwapper.openOriginInfo(player, origin, reason, false, cost, layer);
            }
        })).validResultHandler(response -> {
            if (displayOnly) {
                return;
            }
            if (response.clickedButtonId() == 0) {
                GeyserSwapper.openOriginSwapper(player, reason, false, cost, layer);
            } else {
                Bukkit.getScheduler().runTask((Plugin)OriginsReborn.getInstance(), () -> GeyserSwapper.setOrigin(player, origin, reason, cost, layer));
            }
        })).build());
    }
}

