/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.geysermc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomItemsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineResourcePacksEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreInitializeEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;

public class ORExtension
implements Extension {
    private static ResourcePack pack;
    private static final int BUFFER_SIZE = 4096;

    @Subscribe
    public void onGeyserDefineCustomItems(GeyserDefineCustomItemsEvent event) {
        CustomItemOptions itemOptions = CustomItemOptions.builder().customModelData(1).build();
        CustomItemData data = CustomItemData.builder().name("orb_of_origin").customItemOptions(itemOptions).build();
        event.register("minecraft:nautilus_shell", data);
    }

    @Subscribe
    public void onGeyserDefineResourcePacks(GeyserDefineResourcePacksEvent event) {
        event.register(pack, new ResourcePackOption[0]);
    }

    @Subscribe
    public void onGeyserPreInitialize(GeyserPreInitializeEvent event) throws URISyntaxException {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        this.logger().info("Loading Origins-Reborn extension");
        boolean ignored = this.dataFolder().toFile().mkdirs();
        try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                if (entry.getName().equalsIgnoreCase("bedrock.mcpack")) {
                    ORExtension.extractFile(inputStream, String.valueOf(this.dataFolder()) + "/bedrock.mcpack");
                }
                entry = inputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        pack = ResourcePack.create((PackCodec)PackCodec.path((Path)Path.of(String.valueOf(this.dataFolder()) + "/bedrock.mcpack", new String[0])));
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        int read;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }
}

