/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.util;

import com.starshootercity.APITarget;
import com.starshootercity.OriginsAddon;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.abilities.types.AsyncRepeatingAbility;
import com.starshootercity.abilities.types.AttributeModifierAbility;
import com.starshootercity.abilities.types.BreakSpeedModifierAbility;
import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.DependencyAbility;
import com.starshootercity.abilities.types.FlightAllowingAbility;
import com.starshootercity.abilities.types.ListenerAbility;
import com.starshootercity.abilities.types.MultiAbility;
import com.starshootercity.abilities.types.SkinChangingAbility;
import com.starshootercity.abilities.types.TriggerableAbility;
import com.starshootercity.abilities.types.VisibilityChangingAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.commands.FlightToggleCommand;
import com.starshootercity.util.Pair;
import com.starshootercity.util.TriggerManager;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.util.hooks.GSitHook;
import com.starshootercity.version.MVAccessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

@APITarget
public class AbilityRegister {
    public static Map<Key, Ability> abilityMap = new HashMap<Key, Ability>();
    public static Map<Ability, Key> invertedAbilityMap = new HashMap<Ability, Key>();
    public static Map<Key, OriginsAddon> pluginMap = new HashMap<Key, OriginsAddon>();
    public static Map<Key, DependencyAbility> dependencyAbilityMap = new HashMap<Key, DependencyAbility>();
    public static Map<Key, List<MultiAbility>> multiAbilityMap = new HashMap<Key, List<MultiAbility>>();
    public static List<BreakSpeedModifierAbility> breakSpeedModifierAbilities = new ArrayList<BreakSpeedModifierAbility>();
    public static List<Pair<AttributeModifierAbility, NamespacedKey>> attributeModifierAbilities = new ArrayList<Pair<AttributeModifierAbility, NamespacedKey>>();
    public static List<SkinChangingAbility> skinChangingAbilities = new ArrayList<SkinChangingAbility>();
    public static List<AsyncRepeatingAbility> asyncRepeatingAbilities = new ArrayList<AsyncRepeatingAbility>();
    public static List<FlightAllowingAbility> flightAllowingAbilities = new ArrayList<FlightAllowingAbility>();
    public static Map<Key, List<AbilityRunnable>> runOnRegisters = new HashMap<Key, List<AbilityRunnable>>();
    private static File abilityFile;
    private static FileConfiguration abilityFileConfig;
    private static final Map<String, Object> cache;
    public static List<String> disabledWorlds;
    private static boolean skinManagerEnabled;

    public static <T> void registerConfigOption(JavaPlugin plugin, Ability ability, ConfigManager.SettingType<T> settingType, String path, List<String> comments, T defaultValue) {
        String namespace = AbilityRegister.getNamespace(plugin);
        String pathToUse = namespace + "." + ability.getRegisteredKey().value() + "." + path;
        if (abilityFileConfig.contains(pathToUse)) {
            return;
        }
        settingType.set((ConfigurationSection)abilityFileConfig, pathToUse, defaultValue);
        MVAccessor.get().setComments(abilityFileConfig, pathToUse, comments);
        try {
            abilityFileConfig.save(abilityFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getNamespace(JavaPlugin plugin) {
        if (plugin instanceof OriginsAddon) {
            OriginsAddon addon = (OriginsAddon)plugin;
            return addon.getNamespace();
        }
        return plugin.getName().toLowerCase();
    }

    public static <T> T getConfigOption(JavaPlugin plugin, Ability ability, ConfigManager.SettingType<T> settingType, String path) {
        return (T)cache.computeIfAbsent(AbilityRegister.getNamespace(plugin) + "." + ability.getRegisteredKey().value() + "." + path, s -> settingType.get((ConfigurationSection)abilityFileConfig, (String)s));
    }

    public static void reloadAbilityConfig() {
        cache.clear();
        try {
            abilityFileConfig.load(abilityFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupAbilityConfig(JavaPlugin plugin) {
        abilityFile = new File(plugin.getDataFolder(), "ability-config.yml");
        if (!abilityFile.exists()) {
            boolean ignored = abilityFile.getParentFile().mkdirs();
            plugin.saveResource("ability-config.yml", false);
        }
        abilityFileConfig = new YamlConfiguration();
        AbilityRegister.reloadAbilityConfig();
    }

    public static void initialize(JavaPlugin plugin) {
        disabledWorlds = new ArrayList<String>((Collection)ConfigManager.getConfigValue(ConfigManager.Option.DISABLED_WORLDS));
        MVAccessor.scheduleManager().delayedTask(plugin, () -> {
            for (AsyncRepeatingAbility ability : asyncRepeatingAbilities) {
                ability.start();
            }
            final int[] tick = new int[]{0};
            new BukkitRunnable(){

                public void run() {
                    for (AsyncRepeatingAbility ability : asyncRepeatingAbilities) {
                        if (tick[0] % ability.interval() != 0) continue;
                        ability.run();
                    }
                    tick[0] = tick[0] + 1;
                }
            }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 1L);
        });
    }

    public static void setSkinManagerEnabled() {
        skinManagerEnabled = true;
    }

    public static boolean isSkinManagerEnabled() {
        return skinManagerEnabled;
    }

    public static void registerAbility(Ability ability, Key key, JavaPlugin instance) {
        if (ability instanceof SkinChangingAbility) {
            SkinChangingAbility skinChangingAbility = (SkinChangingAbility)ability;
            if (!AbilityRegister.isSkinManagerEnabled() && !skinChangingAbility.forceEnabled()) {
                return;
            }
            skinChangingAbilities.add(skinChangingAbility);
        }
        invertedAbilityMap.put(ability, key);
        if (instance instanceof OriginsAddon) {
            OriginsAddon addon = (OriginsAddon)instance;
            pluginMap.put(ability.getRegisteredKey(), addon);
        }
        if (runOnRegisters.containsKey(ability.getRegisteredKey())) {
            for (AbilityRunnable abilityRunnable : runOnRegisters.get(ability.getRegisteredKey())) {
                abilityRunnable.run(ability);
            }
        }
        ability.initialize(instance);
        if (ability instanceof DependencyAbility) {
            DependencyAbility dependencyAbility = (DependencyAbility)ability;
            dependencyAbilityMap.put(ability.getRegisteredKey(), dependencyAbility);
        }
        if (ability instanceof AsyncRepeatingAbility) {
            AsyncRepeatingAbility ara = (AsyncRepeatingAbility)ability;
            asyncRepeatingAbilities.add(ara);
        }
        if (ability instanceof FlightAllowingAbility) {
            FlightAllowingAbility flightAllowingAbility = (FlightAllowingAbility)ability;
            flightAllowingAbilities.add(flightAllowingAbility);
            flightAllowingAbilities.sort(Comparator.comparingInt(ab -> -ab.getPriority()));
        }
        if (ability instanceof TriggerableAbility) {
            TriggerableAbility triggerableAbility = (TriggerableAbility)ability;
            TriggerManager.getInstance().register(triggerableAbility);
        }
        if (ability instanceof MultiAbility) {
            MultiAbility multiAbility = (MultiAbility)ability;
            for (Ability a : multiAbility.getAbilities()) {
                multiAbilityMap.computeIfAbsent(a.getKey(), k -> new ArrayList()).add(multiAbility);
            }
        }
        if (ability instanceof CooldownAbility) {
            CooldownAbility cooldownAbility = (CooldownAbility)ability;
            cooldownAbility.setupCooldownConfig(instance);
        }
        if (ability instanceof ListenerAbility) {
            ListenerAbility listenerAbility = (ListenerAbility)ability;
            if (listenerAbility.shouldRegisterEvents()) {
                Bukkit.getPluginManager().registerEvents((Listener)listenerAbility, (Plugin)instance);
            }
        } else if (ability instanceof Listener) {
            Listener listener = (Listener)ability;
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)instance);
        }
        if (ability instanceof VisibleAbility) {
            VisibleAbility visibleAbility = (VisibleAbility)ability;
            visibleAbility.setupTranslatedText();
        }
        if (ability instanceof AttributeModifierAbility) {
            AttributeModifierAbility ama = (AttributeModifierAbility)ability;
            ama.setupAttributeConfig();
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), ability.getRegisteredKey().asString().replace(":", "-"));
            attributeModifierAbilities.add(new Pair<AttributeModifierAbility, NamespacedKey>(ama, namespacedKey));
        }
        if (ability instanceof BreakSpeedModifierAbility) {
            BreakSpeedModifierAbility breakSpeedModifierAbility = (BreakSpeedModifierAbility)ability;
            breakSpeedModifierAbilities.add(breakSpeedModifierAbility);
        }
        abilityMap.put(ability.getRegisteredKey(), ability);
    }

    @Deprecated(forRemoval=true)
    public static void runForAbility(Entity entity, Key key, Runnable runnable) {
        AbilityRegister.runForAbility(entity, key, runnable, () -> {});
    }

    @Deprecated(forRemoval=true)
    public static boolean hasAbility(Player player, Key key) {
        return AbilityRegister.hasAbility(player, key, false);
    }

    @Deprecated(forRemoval=true)
    public static boolean hasAbility(Player player, Key key, boolean ignoreOverrides) {
        if (!abilityMap.containsKey(key)) {
            return false;
        }
        return abilityMap.get(key).hasAbility(player);
    }

    @Deprecated(forRemoval=true)
    public static void runForAbility(Entity entity, Key key, Runnable runnable, Runnable other) {
        Player player;
        if (entity == null) {
            return;
        }
        String worldId = entity.getWorld().getName();
        if (ConfigManager.getConfigValue(ConfigManager.Option.DISABLED_WORLDS).contains(worldId)) {
            return;
        }
        if (entity instanceof Player && AbilityRegister.hasAbility(player = (Player)entity, key)) {
            runnable.run();
            return;
        }
        other.run();
    }

    @Deprecated(forRemoval=true)
    public static void runWithoutAbility(Entity entity, Key key, Runnable runnable) {
        AbilityRegister.runForAbility(entity, key, () -> {}, runnable);
    }

    public static FlyData flyData(Player player, boolean disabledWorld) {
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || FlightToggleCommand.canFly(player)) {
            return new FlyData(true, false);
        }
        if (disabledWorld) {
            return new FlyData(false, false);
        }
        for (FlightAllowingAbility ability : flightAllowingAbilities) {
            if (!ability.hasAbility(player) || !ability.canFly(player)) continue;
            return new FlyData(true, ability.forceFly(player));
        }
        return new FlyData(false, false);
    }

    public static boolean isInvisible(Player player, boolean invisible) {
        if (invisible) {
            return true;
        }
        if (GSitHook.sitting.contains(player.getUniqueId())) {
            return true;
        }
        for (Ability ability : abilityMap.values()) {
            if (!(ability instanceof VisibilityChangingAbility)) continue;
            VisibilityChangingAbility visibilityChangingAbility = (VisibilityChangingAbility)ability;
            if (!ability.hasAbility(player) || !visibilityChangingAbility.isInvisible(player)) continue;
            return true;
        }
        return false;
    }

    public static void updateFlight(Player player, boolean inDisabledWorld) {
        GameMode gm = player.getGameMode();
        if (gm == GameMode.SPECTATOR) {
            return;
        }
        if (gm == GameMode.CREATIVE || FlightToggleCommand.canFly(player)) {
            player.setFlySpeed(0.1f);
            return;
        }
        if (inDisabledWorld) {
            return;
        }
        TriState flyingFallDamage = TriState.FALSE;
        float speed = -1.0f;
        for (FlightAllowingAbility ability : flightAllowingAbilities) {
            if (!ability.hasAbility(player) || !ability.canFly(player)) continue;
            float abilitySpeed = ability.getFlightSpeed(player);
            float f = speed = speed == -1.0f ? abilitySpeed : Math.min(speed, abilitySpeed);
            if (ability.getFlyingFallDamage(player) != TriState.TRUE) continue;
            flyingFallDamage = TriState.TRUE;
        }
        MVAccessor.get().setFlyingFallDamage(player, flyingFallDamage);
        player.setFlySpeed(speed == -1.0f ? 0.0f : speed);
    }

    public static void updateEntity(Player player, Entity target) {
        LivingEntity entity;
        byte data = 0;
        if (target.getFireTicks() > 0) {
            data = (byte)(data + 1);
        }
        if (target.isGlowing()) {
            data = (byte)(data + 64);
        }
        if (target instanceof LivingEntity && (entity = (LivingEntity)target).isInvisible()) {
            data = (byte)(data + 32);
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (targetPlayer.isSneaking()) {
                data = (byte)(data + 2);
            }
            if (targetPlayer.isSprinting()) {
                data = (byte)(data + 8);
            }
            if (targetPlayer.isSwimming()) {
                data = (byte)(data + 16);
            }
            if (targetPlayer.isGliding()) {
                data = (byte)(data - 128);
            }
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                try {
                    ItemStack item = targetPlayer.getInventory().getItem(equipmentSlot);
                    if (item == null) continue;
                    player.sendEquipmentChange((LivingEntity)targetPlayer, equipmentSlot, item);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        MVAccessor.get().sendEntityData(player, target, data);
    }

    static {
        cache = new HashMap<String, Object>();
        skinManagerEnabled = false;
    }

    public static interface AbilityRunnable {
        public void run(Ability var1);
    }

    public record FlyData(boolean canFly, boolean forceFly) {
    }
}

