/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.util;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.BooleanFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.config.ConfigManager;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldGuardHook {
    private static RegionContainer rc;
    private static StringFlag flag;
    private static BooleanFlag flightFlag;

    public static boolean isAbilityDisabled(Location location, Ability ability) {
        try {
            RegionManager manager = rc.get(BukkitAdapter.adapt((World)location.getWorld()));
            if (manager == null) {
                return false;
            }
            ApplicableRegionSet set = manager.getApplicableRegions(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
            for (ProtectedRegion r : set) {
                String data = (String)r.getFlag((Flag)flag);
                if (data == null) continue;
                for (String s : data.split(",")) {
                    if (!s.equals(ability.getRegisteredKey().toString())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isFlightDisabled(Location location) {
        try {
            RegionManager manager = rc.get(BukkitAdapter.adapt((World)location.getWorld()));
            if (manager == null) {
                return false;
            }
            ApplicableRegionSet set = manager.getApplicableRegions(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
            for (ProtectedRegion r : set) {
                Boolean b = (Boolean)r.getFlag((Flag)flightFlag);
                if (b == null || !b.booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean tryInitialize() {
        if (!ConfigManager.getConfigValue(ConfigManager.Option.WORLDGUARD_HOOK).booleanValue()) {
            return false;
        }
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        flag = new StringFlag("origins-reborn:disabled-abilities");
        flightFlag = new BooleanFlag("origins-reborn:disable-flight");
        registry.register((Flag)flag);
        registry.register((Flag)flightFlag);
        return true;
    }

    public static void completeInitialize() {
        rc = WorldGuard.getInstance().getPlatform().getRegionContainer();
    }
}

