/*
 * Decompiled with CFR 0.152.
 */
package ca.bungo.sneakyqol.utility;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PlayerUtility {
    @Nullable
    public static String fetchPlayerSkin(@NotNull class_1657 player) {
        GameProfile playerProfile = player.method_7334();
        Map collection = playerProfile.getProperties().asMap();
        if (collection.containsKey("textures")) {
            Collection textures = (Collection)collection.get("textures");
            Property textureProperty = null;
            for (Property property : textures) {
                if (!property.name().equalsIgnoreCase("textures")) continue;
                textureProperty = property;
                break;
            }
            if (textureProperty != null) {
                String jsonResult = new String(Base64.getDecoder().decode(textureProperty.value()));
                JsonObject jsonObject = JsonParser.parseString((String)jsonResult).getAsJsonObject();
                if (!jsonObject.has("textures")) {
                    return null;
                }
                JsonObject texturesJson = jsonObject.get("textures").getAsJsonObject();
                if (!texturesJson.has("SKIN")) {
                    return null;
                }
                JsonObject skinJson = texturesJson.get("SKIN").getAsJsonObject();
                if (!skinJson.has("url")) {
                    return null;
                }
                return skinJson.get("url").getAsString();
            }
        }
        return null;
    }

    public static class_1657 getTargetPlayer(class_310 client, double range) {
        class_1297 entity2;
        if (client.field_1724 == null || client.field_1687 == null) {
            return null;
        }
        class_243 cameraPos = client.field_1724.method_5836(1.0f);
        class_243 lookVec = client.field_1724.method_5828(1.0f).method_1021(range);
        class_243 endVec = cameraPos.method_1019(lookVec);
        class_238 box = new class_238(cameraPos, endVec).method_1009(1.0, 1.0, 1.0);
        List entities = client.field_1687.method_8390(class_1297.class, box, entity -> entity instanceof class_1657 && entity != client.field_1724);
        class_3966 entityHitResult = null;
        double closestDistance = Double.MAX_VALUE;
        for (class_1297 entity3 : entities) {
            double distance;
            class_238 entityBox = entity3.method_5829().method_1014(0.1);
            class_243 hitResult = entityBox.method_992(cameraPos, endVec).isPresent() ? (class_243)entityBox.method_992(cameraPos, endVec).get() : null;
            if (hitResult == null || !((distance = hitResult.method_1025(cameraPos)) < closestDistance)) continue;
            closestDistance = distance;
            entityHitResult = new class_3966(entity3, hitResult);
        }
        if (entityHitResult == null) {
            return null;
        }
        if (entityHitResult.method_17783() == class_239.class_240.field_1331 && (entity2 = entityHitResult.method_17782()) instanceof class_1657) {
            class_1657 player = (class_1657)entity2;
            return player;
        }
        return null;
    }

    public static List<class_1657> getNearbyPlayers(class_310 client, class_1657 player, double radius) {
        if (client.field_1687 == null) {
            return List.of();
        }
        class_238 box = new class_238(player.method_23317() - radius, player.method_23318() - radius, player.method_23321() - radius, player.method_23317() + radius, player.method_23318() + radius, player.method_23321() + radius);
        return client.field_1687.method_8390(class_1657.class, box, p -> p != player);
    }

    public static List<class_1657> getAllPlayers(class_310 client) {
        if (client.field_1687 == null) {
            return List.of();
        }
        return client.field_1687.method_18456().stream().map(s -> s).toList();
    }
}

