/*
 * Decompiled with CFR 0.152.
 */
package ca.bungo.sneakyqol.utility;

import ca.bungo.sneakyqol.SneakyQOL;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ResourceExtractor {
    public static File extractResourceToConfig(String resourcePath, String configDir) throws IOException {
        File modelDir = new File(configDir, resourcePath);
        if (modelDir.exists() && modelDir.isDirectory()) {
            return modelDir;
        }
        InputStream resourceStream = ResourceExtractor.class.getClassLoader().getResourceAsStream(resourcePath);
        if (resourceStream == null) {
            throw new FileNotFoundException("Resource not found: " + resourcePath);
        }
        ResourceExtractor.copyInputStreamToFile(resourceStream, modelDir);
        return modelDir;
    }

    private static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileOutputStream out = new FileOutputStream(destination);){
            int length;
            while ((length = source.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyDirectoryFromResources(String resourcePath, File targetDir) throws IOException {
        Path targetPath = targetDir.toPath();
        try (InputStream is = SneakyQOL.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (is == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            try (ZipInputStream zis = new ZipInputStream(is);){
                ZipEntry zipEntry;
                block15: while ((zipEntry = zis.getNextEntry()) != null) {
                    Path newPath = ResourceExtractor.zipSlipProtect(zipEntry, targetPath);
                    if (zipEntry.isDirectory()) {
                        Files.createDirectories(newPath, new FileAttribute[0]);
                        continue;
                    }
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    OutputStream fos = Files.newOutputStream(newPath, new OpenOption[0]);
                    try {
                        byte[] buffer = new byte[1024];
                        while (true) {
                            int len;
                            if ((len = zis.read(buffer)) <= 0) continue block15;
                            fos.write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
                return;
            }
        }
    }

    private static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }
}

