/*
 * Decompiled with CFR 0.152.
 */
package ca.bungo.sneakyqol.vtt;

import ca.bungo.sneakyqol.SneakyQOL;
import ca.bungo.sneakyqol.settings.keybindings.VoiceToTextKeybind;
import ca.bungo.sneakyqol.vtt.MicrophoneHandler;
import ca.bungo.sneakyqol.vtt.SpeechRecognizer;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.vosk.Model;

@Environment(value=EnvType.CLIENT)
public class EventHandlerVTT {
    private static MicrophoneHandler microphoneHandler;
    private static SpeechRecognizer speechRecognizer;
    private static String lastResult;
    private static Thread listenThread;

    public static void register() {
        ClientLifecycleEvents.CLIENT_STARTED.register(EventHandlerVTT::handelClientStartEvent);
        ClientTickEvents.END_CLIENT_TICK.register(EventHandlerVTT::handleEndClientTickEvent);
        ClientTickEvents.START_CLIENT_TICK.register(EventHandlerVTT::handleStartClientTickEvent);
        ClientLifecycleEvents.CLIENT_STOPPING.register(EventHandlerVTT::handleClientStopEvent);
    }

    public static void resetBuffers() {
        lastResult = "";
    }

    private static void listenThreadTask() {
        while (true) {
            try {
                while (true) {
                    if (speechRecognizer == null) {
                        if (class_310.method_1551().field_1724 != null) {
                            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7cAcoustic Model Load Failed"), true);
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            continue;
                        }
                        speechRecognizer = new SpeechRecognizer(new Model(), 16000);
                        continue;
                    }
                    if (microphoneHandler == null) {
                        listenThread.wait(10000L);
                        microphoneHandler = new MicrophoneHandler(new AudioFormat(16000.0f, 16, 1, true, false));
                        microphoneHandler.startListening();
                        continue;
                    }
                    String tmp = speechRecognizer.getStringMsg(microphoneHandler.readData());
                    if (tmp.equals("") || tmp.equals(lastResult) || !VoiceToTextKeybind.wasPressed) continue;
                    lastResult = tmp;
                }
            }
            catch (Exception e) {
                SneakyQOL.LOGGER.error(e.getMessage());
                continue;
            }
            break;
        }
    }

    private static void handelClientStartEvent(class_310 client) {
        File configDir = new File(FabricLoader.getInstance().getConfigDir().toString(), "sneakyqol");
        File modelDir = new File(configDir, "vosk-model");
        SneakyQOL.LOGGER.info("Loading acoustic model from " + modelDir.getPath() + "   ...");
        try {
            speechRecognizer = new SpeechRecognizer(new Model(modelDir.getAbsolutePath()), 16000);
            SneakyQOL.LOGGER.info("Acoustic model loaded successfully!");
        }
        catch (Exception e1) {
            SneakyQOL.LOGGER.error(e1.getMessage());
        }
        try {
            microphoneHandler = new MicrophoneHandler(new AudioFormat(16000.0f, 16, 1, true, false));
            microphoneHandler.startListening();
            SneakyQOL.LOGGER.info("Microphone handler initialized successfully!");
        }
        catch (Exception e2) {
            SneakyQOL.LOGGER.error(e2.getMessage());
        }
        listenThread = new Thread(EventHandlerVTT::listenThreadTask);
        listenThread.start();
    }

    private static void handleClientStopEvent(class_310 client) {
        listenThread.interrupt();
        microphoneHandler.stopListening();
        speechRecognizer = null;
        microphoneHandler = null;
        listenThread = null;
    }

    private static void handleEndClientTickEvent(class_310 client) {
        if (client.field_1724 != null && VoiceToTextKeybind.wasPressed && microphoneHandler != null && !lastResult.equals("")) {
            client.field_1724.field_3944.method_45729("(VTT) " + lastResult);
            client.field_1724.method_7353(class_2561.method_30163((String)"\u00a7aMessage Sent"), true);
            lastResult = "";
        }
    }

    private static void handleStartClientTickEvent(class_310 client) {
        if (client.field_1724 != null && VoiceToTextKeybind.wasPressed) {
            client.field_1724.method_7353(class_2561.method_30163((String)"\u00a7eRecording & Recognizing..."), true);
        } else if (lastResult.length() > 0) {
            lastResult = "";
        }
    }

    static {
        lastResult = "";
    }
}

