/*
 * Decompiled with CFR 0.152.
 */
package ca.bungo.sneakyqol.vtt;

import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.vosk.Model;
import org.vosk.Recognizer;

@Environment(value=EnvType.CLIENT)
public class SpeechRecognizer {
    public Recognizer recognizer;

    public SpeechRecognizer(Model model, int sampleRate) throws Exception {
        if (model == null) {
            throw new Exception("Acoustic model not loaded.");
        }
        this.recognizer = new Recognizer(model, (float)sampleRate);
    }

    public String getStringMsg(byte[] data) {
        if (this.recognizer.acceptWaveForm(data, data.length)) {
            return JsonParser.parseString((String)this.recognizer.getResult()).getAsJsonObject().get("text").getAsString();
        }
        return "";
    }

    public static String repairEncoding(String str, String srcEncoding, String dstEncoding) throws UnsupportedEncodingException {
        return new String(str.getBytes(srcEncoding), dstEncoding);
    }
}

