/*
 * Decompiled with CFR 0.152.
 */
package ca.bungo.sneakyqol.vtt;

import ca.bungo.sneakyqol.SneakyQOL;
import ca.bungo.sneakyqol.utility.ResourceExtractor;
import ca.bungo.sneakyqol.utility.SneakyToasts;
import ca.bungo.sneakyqol.vtt.MicrophoneHandler;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.vosk.LibVosk;
import org.vosk.LogLevel;
import org.vosk.Model;
import org.vosk.Recognizer;

@Environment(value=EnvType.CLIENT)
public class VoiceToText {
    private static final int SAMPLE_RATE = 16000;
    private static boolean isEnabled = false;
    private static File CONFIG_DIR;
    private static MicrophoneHandler microphoneHandler;

    public static void initialize(File configDir) {
        try {
            CONFIG_DIR = configDir;
            File modelDir = new File(configDir, "vosk-model");
            ResourceExtractor.copyDirectoryFromResources("models/vosk-model.zip", modelDir);
            LibVosk.setLogLevel((LogLevel)LogLevel.WARNINGS);
            isEnabled = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            isEnabled = false;
        }
    }

    public static void startVoiceRecognition() {
        if (!isEnabled) {
            return;
        }
        try {
            if (microphoneHandler == null) {
                microphoneHandler = new MicrophoneHandler(new AudioFormat(16000.0f, 16, 1, true, false));
            }
            microphoneHandler.startListening();
            System.out.println("Started listening...");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void playbackAudio(byte[] audioData) {
        new Thread(() -> {
            try {
                AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, true);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                if (!AudioSystem.isLineSupported(info)) {
                    System.err.println("Playback line not supported");
                    return;
                }
                SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format);
                line.start();
                line.write(audioData, 0, audioData.length);
                line.drain();
                line.close();
                System.out.println("Audio playback completed.");
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                System.err.println("Failed to play back audio.");
            }
        }).start();
    }

    public static void stopVoiceRecognitionAndProcess() {
        if (microphoneHandler != null) {
            microphoneHandler.stopListening();
            byte[] audioData = microphoneHandler.readData();
            if (audioData != null) {
                VoiceToText.playbackAudio(audioData);
                VoiceToText.processAudioData(audioData);
            } else {
                System.err.println("No audio data read from microphone.");
            }
        } else {
            System.err.println("Microphone handler is null.");
        }
    }

    private static void processAudioData(byte[] audioData) {
        new Thread(() -> {
            try {
                File modelDir = new File(CONFIG_DIR, "vosk-model");
                try (Model model = new Model(modelDir.getAbsolutePath());
                     Recognizer recognizer = new Recognizer(model, 16000.0f);){
                    System.out.println("Processing audio data...");
                    if (recognizer.acceptWaveForm(audioData, audioData.length)) {
                        SneakyQOL.LOGGER.info(JsonParser.parseString((String)recognizer.getResult()).getAsJsonObject().get("text").getAsString());
                    }
                    System.out.println(recognizer.getFinalResult());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                class_310.method_1551().execute(() -> SneakyToasts.showToast(class_2561.method_30163((String)"Voice Recognition"), class_2561.method_30163((String)"Failed to Process"), class_310.method_1551().method_1566()));
            }
        }).start();
    }

    static {
        microphoneHandler = null;
    }
}

