/*
 * Decompiled with CFR 0.152.
 */
package jonyboylovespie.lockedchestplugin.lockedChestsPlugin;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestOwnershipListener
implements Listener,
CommandExecutor {
    private JavaPlugin plugin;
    private NamespacedKey ownerKey;
    private NamespacedKey trustedKey;

    public ChestOwnershipListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.ownerKey = new NamespacedKey((Plugin)plugin, "owner");
        this.trustedKey = new NamespacedKey((Plugin)plugin, "trusted");
        this.plugin.getCommand("trust").setExecutor((CommandExecutor)this);
        this.plugin.getCommand("lockchest").setExecutor((CommandExecutor)this);
        this.plugin.getCommand("lockinspect").setExecutor((CommandExecutor)this);
    }

    private void removeOwnership(Chest chest) {
        chest.getPersistentDataContainer().remove(this.ownerKey);
        chest.getPersistentDataContainer().remove(this.trustedKey);
        InventoryHolder inventoryHolder = chest.getInventory().getHolder();
        if (inventoryHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            Chest otherPart = (Chest)(chest.equals((Object)doubleChest.getRightSide()) ? doubleChest.getLeftSide() : doubleChest.getRightSide());
            otherPart.getPersistentDataContainer().remove(this.ownerKey);
            otherPart.getPersistentDataContainer().remove(this.trustedKey);
            otherPart.update();
        }
        chest.update();
    }

    private void setOwnership(Player owner, Chest chest) {
        chest.getPersistentDataContainer().set(this.ownerKey, PersistentDataType.STRING, (Object)owner.getUniqueId().toString());
        chest.update();
    }

    private void addTrustedPlayer(Player player, Chest chest) {
        Object trustedPlayers = (String)chest.getPersistentDataContainer().get(this.trustedKey, PersistentDataType.STRING);
        trustedPlayers = trustedPlayers == null ? player.getUniqueId().toString() : (String)trustedPlayers + "," + String.valueOf(player.getUniqueId());
        chest.getPersistentDataContainer().set(this.trustedKey, PersistentDataType.STRING, trustedPlayers);
        chest.update();
    }

    private String getOwner(Chest chest) {
        String owner = (String)chest.getPersistentDataContainer().get(this.ownerKey, PersistentDataType.STRING);
        InventoryHolder inventoryHolder = chest.getInventory().getHolder();
        if (inventoryHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            Chest otherPart = (Chest)(chest.equals((Object)doubleChest.getRightSide()) ? doubleChest.getLeftSide() : doubleChest.getRightSide());
            if (owner == null) {
                owner = (String)otherPart.getPersistentDataContainer().get(this.ownerKey, PersistentDataType.STRING);
            }
        }
        return owner;
    }

    private String[] getTrustedPlayers(Chest chest) {
        String finalTrusted;
        InventoryHolder inventoryHolder = chest.getInventory().getHolder();
        if (inventoryHolder instanceof DoubleChest) {
            String otherTrusted;
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            String trusted = (String)chest.getPersistentDataContainer().get(this.trustedKey, PersistentDataType.STRING);
            Chest otherPart = (Chest)(chest.equals((Object)doubleChest.getRightSide()) ? doubleChest.getLeftSide() : doubleChest.getRightSide());
            CharSequence[] trustedPlayers = new String[]{};
            if (trusted != null) {
                trustedPlayers = trusted.split(",");
            }
            if ((otherTrusted = (String)otherPart.getPersistentDataContainer().get(this.trustedKey, PersistentDataType.STRING)) != null) {
                String[] otherTrustedPlayers = otherTrusted.split(",");
                String[] combined = new String[trustedPlayers.length + otherTrustedPlayers.length];
                System.arraycopy(trustedPlayers, 0, combined, 0, trustedPlayers.length);
                System.arraycopy(otherTrustedPlayers, 0, combined, trustedPlayers.length, otherTrustedPlayers.length);
                trustedPlayers = combined;
            }
            String trustedPlayersString = String.join((CharSequence)",", trustedPlayers);
            chest.getPersistentDataContainer().set(this.trustedKey, PersistentDataType.STRING, (Object)trustedPlayersString);
            chest.update();
            otherPart.getPersistentDataContainer().set(this.trustedKey, PersistentDataType.STRING, (Object)trustedPlayersString);
            otherPart.update();
        }
        return (finalTrusted = (String)chest.getPersistentDataContainer().get(this.trustedKey, PersistentDataType.STRING)) != null ? finalTrusted.split(",") : new String[]{};
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        InventoryHolder inventoryHolder;
        Block block = event.getBlock();
        if (block.getType() != Material.CHEST) {
            return;
        }
        Player player = event.getPlayer();
        Chest chest = (Chest)block.getState();
        String owner = this.getOwner(chest);
        if (owner == null) {
            return;
        }
        UUID ownerUUID = UUID.fromString(owner);
        if (!ownerUUID.equals(player.getUniqueId())) {
            player.sendMessage("You cannot break this chest, it is locked by " + Bukkit.getOfflinePlayer((UUID)ownerUUID).getName());
            event.setCancelled(true);
        }
        if ((inventoryHolder = chest.getInventory().getHolder()) instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            Chest otherPart = (Chest)(chest.equals((Object)doubleChest.getRightSide()) ? doubleChest.getLeftSide() : doubleChest.getRightSide());
            this.setOwnership(player, otherPart);
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Block sourceBlock = event.getSource().getLocation().getBlock();
        if (sourceBlock.getType() != Material.CHEST) {
            return;
        }
        Chest chest = (Chest)sourceBlock.getState();
        if (this.getOwner(chest) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (block.getType() != Material.CHEST) {
            return;
        }
        Player player = event.getPlayer();
        Chest chest = (Chest)block.getState();
        this.handleChestInteraction(player, chest, event);
    }

    private void handleChestInteraction(Player player, Chest chest, PlayerInteractEvent event) {
        UUID playerUUID = player.getUniqueId();
        String owner = this.getOwner(chest);
        String[] trustedPlayers = this.getTrustedPlayers(chest);
        if (player.isSneaking() && this.isKeyItem(player.getInventory().getItemInMainHand()) || this.isKeyItem(player.getInventory().getItemInOffHand())) {
            this.handleLocking(player, chest);
            return;
        }
        if (owner == null) {
            return;
        }
        UUID ownerUUID = UUID.fromString(owner);
        if (ownerUUID.equals(playerUUID) || this.isPlayerTrusted(playerUUID.toString(), trustedPlayers)) {
            return;
        }
        player.sendMessage("You cannot open this chest, it is locked by " + Bukkit.getOfflinePlayer((UUID)ownerUUID).getName());
        event.setCancelled(true);
    }

    private boolean isPlayerTrusted(String playerUUID, String[] trustedPlayers) {
        for (String trustedPlayer : trustedPlayers) {
            if (!trustedPlayer.equals(playerUUID)) continue;
            return true;
        }
        return false;
    }

    private void handleLocking(Player player, Chest chest) {
        String owner = this.getOwner(chest);
        if (owner == null) {
            this.handleAddLock(player, chest);
            return;
        }
        this.handleRemoveLock(player, chest);
    }

    private boolean isKeyItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.hasDisplayName() && meta.getDisplayName().equalsIgnoreCase("Key") && (item.getType() == Material.IRON_NUGGET || item.getType() == Material.GOLD_NUGGET);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("trust")) {
            return this.handleTrustCommand(player, args);
        }
        if (command.getName().equalsIgnoreCase("lockchest")) {
            return this.handleLockChestCommand(player, args);
        }
        if (command.getName().equalsIgnoreCase("lockinspect")) {
            return this.handleLockInspectCommand(player, args);
        }
        return false;
    }

    private boolean handleTrustCommand(Player player, String[] args) {
        if (args.length != 1) {
            return false;
        }
        Block block = player.getTargetBlockExact(5);
        if (block == null || block.getType() != Material.CHEST) {
            player.sendMessage("You must be looking at a chest.");
            return true;
        }
        Chest chest = (Chest)block.getState();
        if (!this.isPlayerOwner(player, chest)) {
            player.sendMessage("You do not own this chest.");
            return true;
        }
        Player trustedPlayer = Bukkit.getPlayer((String)args[0]);
        if (trustedPlayer == null) {
            player.sendMessage("Player " + args[0] + " is not online.");
            return true;
        }
        for (String playerUUID : this.getTrustedPlayers(chest)) {
            if (!trustedPlayer.getUniqueId().toString().equals(playerUUID)) continue;
            player.sendMessage("Player " + trustedPlayer.getName() + " is already trusted.");
            return true;
        }
        this.addTrustedPlayer(trustedPlayer, chest);
        player.sendMessage("Player " + trustedPlayer.getName() + " has been trusted.");
        return true;
    }

    private boolean handleLockChestCommand(Player player, String[] args) {
        if (args.length != 1) {
            return false;
        }
        String action = args[0].toLowerCase();
        if (!action.equals("add") && !action.equals("remove")) {
            player.sendMessage("Must follow /lockchest with add or remove.");
            return false;
        }
        Block block = player.getTargetBlockExact(5);
        if (block == null || block.getType() != Material.CHEST) {
            player.sendMessage("You must be looking at a chest.");
            return true;
        }
        Chest chest = (Chest)block.getState();
        if (action.equals("add")) {
            this.handleAddLock(player, chest);
            return true;
        }
        this.handleRemoveLock(player, chest);
        return true;
    }

    private boolean handleLockInspectCommand(Player player, String[] args) {
        if (args.length != 0) {
            return false;
        }
        Block block = player.getTargetBlockExact(5);
        if (block == null || block.getType() != Material.CHEST) {
            player.sendMessage("You must be looking at a chest.");
            return true;
        }
        Chest chest = (Chest)block.getState();
        String owner = this.getOwner(chest);
        if (owner == null) {
            player.sendMessage("This chest is not locked.");
            return true;
        }
        player.sendMessage(owner);
        return true;
    }

    private void handleAddLock(Player player, Chest chest) {
        String ownerUUID = this.getOwner(chest);
        if (ownerUUID == null) {
            this.setOwnership(player, chest);
            player.sendMessage("Locking chest.");
            return;
        }
        if (!this.isPlayerOwner(player, chest)) {
            player.sendMessage("You cannot lock this chest, it is locked by " + Bukkit.getOfflinePlayer((UUID)UUID.fromString(ownerUUID)).getName());
            return;
        }
        player.sendMessage("This chest is already locked by you.");
    }

    private void handleRemoveLock(Player player, Chest chest) {
        String ownerUUID = this.getOwner(chest);
        if (ownerUUID == null) {
            this.setOwnership(player, chest);
            player.sendMessage("This chest is not locked.");
            return;
        }
        if (!this.isPlayerOwner(player, chest) && !player.isOp()) {
            player.sendMessage("You cannot unlock this chest, it is locked by " + Bukkit.getOfflinePlayer((UUID)UUID.fromString(ownerUUID)).getName());
            return;
        }
        this.removeOwnership(chest);
        player.sendMessage("Unlocking chest.");
    }

    private boolean isPlayerOwner(Player player, Chest chest) {
        String owner = this.getOwner(chest);
        if (owner == null) {
            return false;
        }
        UUID ownerUUID = UUID.fromString(owner);
        return ownerUUID.equals(player.getUniqueId());
    }
}

