/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.commands.registrar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.bloodred.customcrafty.CustomCraftyPlugin;
import me.bloodred.customcrafty.commands.CustomCraftyCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyCommand {
    private final CustomCraftyPlugin plugin;
    private final CustomCraftyCommand commandHandler;

    public LegacyCommand(CustomCraftyPlugin plugin, CustomCraftyCommand commandHandler) {
        this.plugin = plugin;
        this.commandHandler = commandHandler;
    }

    public void registerCommands() {
        CustomCraftyBukkitCommand mainCommand = new CustomCraftyBukkitCommand();
        this.plugin.getServer().getCommandMap().register("customcrafty", (Command)mainCommand);
        this.plugin.getServer().getCommandMap().register("cc", (Command)new AliasBukkitCommand("cc", mainCommand));
    }

    private class CustomCraftyBukkitCommand
    extends BukkitCommand {
        public CustomCraftyBukkitCommand() {
            super("customcrafty", "Main command for CustomCrafty", "/customcrafty [reload|list|create|remove|help]", Arrays.asList("cc"));
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
            if (!sender.hasPermission("customcrafty.admin")) {
                sender.sendMessage(LegacyCommand.this.plugin.getPrefix().append(Component.text((String)"You don't have permission to use this command!").color(TextColor.color((int)0xFF0000))));
                return true;
            }
            return LegacyCommand.this.commandHandler.onCommand(sender, (Command)this, commandLabel, args);
        }

        @Nullable
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            if (!sender.hasPermission("customcrafty.admin")) {
                return new ArrayList<String>();
            }
            return LegacyCommand.this.commandHandler.onTabComplete(sender, (Command)this, alias, args);
        }
    }

    private static class AliasBukkitCommand
    extends BukkitCommand {
        private final CustomCraftyBukkitCommand parentCommand;

        public AliasBukkitCommand(String name, CustomCraftyBukkitCommand parentCommand) {
            super(name, "Alias for CustomCrafty command", "/" + name + " [reload|list|create|remove|help]", List.of());
            this.parentCommand = parentCommand;
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
            return this.parentCommand.execute(sender, "customcrafty", args);
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            ArrayList result = this.parentCommand.tabComplete(sender, alias, args);
            return result != null ? result : new ArrayList();
        }
    }
}

