/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.listeners;

import me.bloodred.customcrafty.managers.RecipeManager;
import me.bloodred.customcrafty.models.CustomRecipe;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class CraftingListener
implements Listener {
    private final RecipeManager recipeManager;

    public CraftingListener(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        CustomRecipe matchingRecipe = this.recipeManager.findMatchingRecipe(matrix);
        if (matchingRecipe != null) {
            Player player;
            Object e;
            if (!inventory.getViewers().isEmpty() && (e = inventory.getViewers().get(0)) instanceof Player && !(player = (Player)e).hasPermission("customcrafty.craft")) {
                inventory.setResult(null);
                return;
            }
            ItemStack result = matchingRecipe.getResult().clone();
            if (matchingRecipe.isPreserveNBT()) {
                result = this.preserveNBTFromIngredients(result, matrix, matchingRecipe);
            }
            inventory.setResult(result);
        }
    }

    private ItemStack preserveNBTFromIngredients(ItemStack result, ItemStack[] matrix, CustomRecipe recipe) {
        for (ItemStack ingredient : matrix) {
            if (ingredient == null || !ingredient.hasItemMeta()) continue;
            if (ingredient.getItemMeta().hasDisplayName() && ingredient.getType() == result.getType()) {
                result.getItemMeta().setDisplayName(ingredient.getItemMeta().getDisplayName());
            }
            if (!ingredient.getItemMeta().hasEnchants()) continue;
            ingredient.getItemMeta().getEnchants().forEach((enchant, level) -> result.addUnsafeEnchantment(enchant, level.intValue()));
        }
        return result;
    }
}

