/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.bloodred.customcrafty.CustomCraftyPlugin;
import me.bloodred.customcrafty.managers.RecipeManager;
import me.bloodred.customcrafty.models.CustomRecipe;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager
implements Listener {
    private final CustomCraftyPlugin plugin;
    private final RecipeManager recipeManager;
    private final Map<UUID, String> openGUIs = new HashMap<UUID, String>();
    private static final int[] CRAFTING_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private static final int RESULT_SLOT = 24;
    private static final int CREATE_BUTTON_SLOT = 25;
    private static final int CANCEL_BUTTON_SLOT = 23;

    public GUIManager(CustomCraftyPlugin plugin, RecipeManager recipeManager) {
        this.plugin = plugin;
        this.recipeManager = recipeManager;
    }

    public void openRecipeCreationGUI(Player player, String recipeName) {
        if (this.recipeManager.getRecipe(recipeName) != null) {
            player.sendMessage(this.plugin.getPrefix().append(((TextComponent)((TextComponent)Component.text((String)"Recipe '").append(Component.text((String)recipeName).color(TextColor.color((int)0xFFFF00)))).append((Component)Component.text((String)"' already exists! Removing existing recipe..."))).color(TextColor.color((int)0xFFFF00))));
            this.recipeManager.removeRecipe(recipeName);
        }
        Inventory gui = Bukkit.createInventory(null, (int)45, (Component)Component.text((String)("Recipe Creator: " + recipeName)));
        ItemStack blueGlass = new ItemStack(Material.BLUE_STAINED_GLASS_PANE);
        ItemMeta glassMeta = blueGlass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.displayName((Component)Component.text((String)" "));
            blueGlass.setItemMeta(glassMeta);
        }
        for (int i = 0; i < 45; ++i) {
            gui.setItem(i, blueGlass);
        }
        for (int slot : CRAFTING_SLOTS) {
            gui.setItem(slot, null);
        }
        gui.setItem(24, null);
        gui.setItem(25, this.createButton(Material.EMERALD_BLOCK, "Create Recipe", "Click to create the recipe"));
        gui.setItem(23, this.createButton(Material.REDSTONE_BLOCK, "Cancel", "Click to cancel recipe creation"));
        this.openGUIs.put(player.getUniqueId(), recipeName);
        player.openInventory(gui);
    }

    private ItemStack createButton(Material material, String name, String lore) {
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text((String)name).color((TextColor)NamedTextColor.WHITE));
            meta.lore(Arrays.asList((TextComponent)Component.text((String)lore).color((TextColor)NamedTextColor.GRAY)));
            button.setItemMeta(meta);
        }
        return button;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.openGUIs.containsKey(player.getUniqueId())) {
            return;
        }
        String recipeName = this.openGUIs.get(player.getUniqueId());
        Inventory gui = event.getInventory();
        if (!gui.getViewers().contains(player)) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot == 25) {
            event.setCancelled(true);
            this.handleCreateButton(player, gui, recipeName);
            return;
        }
        if (slot == 23) {
            event.setCancelled(true);
            this.handleCancelButton(player);
            return;
        }
        if (this.isValidCraftingSlot(slot)) {
            return;
        }
        if (slot == 24) {
            return;
        }
        if (slot >= 0 && slot < gui.getSize()) {
            event.setCancelled(true);
        }
    }

    private void handleCreateButton(Player player, Inventory gui, String recipeName) {
        ItemStack result = gui.getItem(24);
        if (result == null || result.getType() == Material.AIR) {
            player.sendMessage(this.plugin.getPrefix().append(Component.text((String)"Please place a result item in the result slot!").color(TextColor.color((int)0xFF0000))));
            return;
        }
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        boolean hasIngredients = false;
        for (int slot : CRAFTING_SLOTS) {
            ItemStack item = gui.getItem(slot);
            if (item != null && item.getType() != Material.AIR) {
                ingredients.add(item.clone());
                hasIngredients = true;
                continue;
            }
            ingredients.add(null);
        }
        if (!hasIngredients) {
            player.sendMessage(this.plugin.getPrefix().append(Component.text((String)"Please place at least one ingredient in the crafting grid!").color(TextColor.color((int)0xFF0000))));
            return;
        }
        if (this.isValidShapedRecipe(ingredients)) {
            this.createShapedRecipe(player, recipeName, result, ingredients);
        } else {
            this.createShapelessRecipe(player, recipeName, result, ingredients);
        }
        player.closeInventory();
    }

    private void handleCancelButton(Player player) {
        player.sendMessage(this.plugin.getPrefix().append(Component.text((String)"Recipe creation cancelled.").color(TextColor.color((int)0xFFFF00))));
        player.closeInventory();
    }

    private boolean isValidCraftingSlot(int slot) {
        for (int validSlot : CRAFTING_SLOTS) {
            if (slot != validSlot) continue;
            return true;
        }
        return false;
    }

    private boolean isValidShapedRecipe(List<ItemStack> ingredients) {
        return true;
    }

    private void createShapedRecipe(Player player, String recipeName, ItemStack result, List<ItemStack> ingredients) {
        CustomRecipe recipe = new CustomRecipe(recipeName, recipeName, CustomRecipe.RecipeType.SHAPED, result.clone());
        ArrayList<String> shape = new ArrayList<String>();
        HashMap<Character, ItemStack> ingredientMap = new HashMap<Character, ItemStack>();
        char currentChar = 'A';
        for (int row = 0; row < 3; ++row) {
            StringBuilder shapeRow = new StringBuilder();
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                ItemStack item = ingredients.get(index);
                if (item != null && item.getType() != Material.AIR) {
                    char itemChar = ' ';
                    for (Map.Entry entry : ingredientMap.entrySet()) {
                        if (((ItemStack)entry.getValue()).getType() != item.getType()) continue;
                        itemChar = ((Character)entry.getKey()).charValue();
                        break;
                    }
                    if (itemChar == ' ') {
                        char c = currentChar;
                        currentChar = (char)(currentChar + 1);
                        itemChar = c;
                        ingredientMap.put(Character.valueOf(itemChar), item.clone());
                    }
                    shapeRow.append(itemChar);
                    continue;
                }
                shapeRow.append(' ');
            }
            shape.add(shapeRow.toString());
        }
        recipe.setShape(shape);
        recipe.setIngredients(ingredientMap);
        this.recipeManager.addRecipe(recipe);
        player.sendMessage(this.plugin.getPrefix().append(((TextComponent)((TextComponent)Component.text((String)"Shaped recipe '").append(Component.text((String)recipeName).color(TextColor.color((int)0xFFFF00)))).append((Component)Component.text((String)"' created successfully!"))).color(TextColor.color((int)65280))));
    }

    private void createShapelessRecipe(Player player, String recipeName, ItemStack result, List<ItemStack> ingredients) {
        CustomRecipe recipe = new CustomRecipe(recipeName, recipeName, CustomRecipe.RecipeType.SHAPELESS, result.clone());
        ArrayList<ItemStack> shapelessIngredients = new ArrayList<ItemStack>();
        for (ItemStack item : ingredients) {
            if (item == null || item.getType() == Material.AIR) continue;
            shapelessIngredients.add(item.clone());
        }
        recipe.setShapelessIngredients(shapelessIngredients);
        this.recipeManager.addRecipe(recipe);
        player.sendMessage(this.plugin.getPrefix().append(((TextComponent)((TextComponent)Component.text((String)"Shapeless recipe '").append(Component.text((String)recipeName).color(TextColor.color((int)0xFFFF00)))).append((Component)Component.text((String)"' created successfully!"))).color(TextColor.color((int)65280))));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            this.openGUIs.remove(player.getUniqueId());
        }
    }
}

