/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.bloodred.customcrafty.CustomCraftyPlugin;
import me.bloodred.customcrafty.models.CustomRecipe;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeManager {
    private final CustomCraftyPlugin plugin;
    private final Map<String, CustomRecipe> customRecipes;
    private File recipesFile;
    private FileConfiguration recipesConfig;

    public RecipeManager(CustomCraftyPlugin plugin) {
        this.plugin = plugin;
        this.customRecipes = new HashMap<String, CustomRecipe>();
        this.recipesFile = new File(plugin.getDataFolder(), "recipes.yml");
        if (!this.recipesFile.exists()) {
            plugin.saveResource("recipes.yml", false);
        }
        this.recipesConfig = YamlConfiguration.loadConfiguration((File)this.recipesFile);
    }

    public void loadRecipes() {
        this.customRecipes.clear();
        ConfigurationSection recipesSection = this.recipesConfig.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return;
        }
        for (String id : recipesSection.getKeys(false)) {
            ConfigurationSection recipeSection = recipesSection.getConfigurationSection(id);
            if (recipeSection == null) continue;
            try {
                CustomRecipe recipe = this.loadRecipeFromConfig(id, recipeSection);
                if (recipe == null) continue;
                this.customRecipes.put(id, recipe);
                this.registerRecipeWithBukkit(recipe);
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Loaded custom recipe: " + id)).color(TextColor.color((int)65280))));
            }
            catch (Exception e) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Failed to load recipe " + id + ": " + e.getMessage())).color(TextColor.color((int)0xFFFF00))));
            }
        }
        this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Loaded " + this.customRecipes.size() + " custom recipes")).color(TextColor.color((int)65280))));
    }

    private CustomRecipe loadRecipeFromConfig(String id, ConfigurationSection section) {
        String name = section.getString("name", id);
        String typeStr = section.getString("type", "SHAPED");
        CustomRecipe.RecipeType type = CustomRecipe.RecipeType.valueOf(typeStr.toUpperCase());
        ItemStack result = this.loadItemFromConfig(section.getConfigurationSection("result"));
        if (result == null) {
            return null;
        }
        CustomRecipe recipe = new CustomRecipe(id, name, type, result);
        recipe.setExactMatch(section.getBoolean("exactMatch", false));
        recipe.setPreserveNBT(section.getBoolean("preserveNBT", true));
        if (type == CustomRecipe.RecipeType.SHAPED) {
            this.loadShapedRecipe(recipe, section);
        } else {
            this.loadShapelessRecipe(recipe, section);
        }
        return recipe;
    }

    private void loadShapedRecipe(CustomRecipe recipe, ConfigurationSection section) {
        List shape = section.getStringList("shape");
        recipe.setShape(shape);
        HashMap<Character, ItemStack> ingredients = new HashMap<Character, ItemStack>();
        ConfigurationSection ingredientsSection = section.getConfigurationSection("ingredients");
        if (ingredientsSection != null) {
            for (String key : ingredientsSection.getKeys(false)) {
                if (key.length() != 1) continue;
                char character = key.charAt(0);
                ItemStack item = this.loadItemFromConfig(ingredientsSection.getConfigurationSection(key));
                if (item == null) continue;
                ingredients.put(Character.valueOf(character), item);
            }
        }
        recipe.setIngredients(ingredients);
    }

    private void loadShapelessRecipe(CustomRecipe recipe, ConfigurationSection section) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ConfigurationSection ingredientsSection = section.getConfigurationSection("ingredients");
        if (ingredientsSection != null) {
            for (String key : ingredientsSection.getKeys(false)) {
                ItemStack item = this.loadItemFromConfig(ingredientsSection.getConfigurationSection(key));
                if (item == null) continue;
                ingredients.add(item);
            }
        }
        recipe.setShapelessIngredients(ingredients);
    }

    private ItemStack loadItemFromConfig(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        String materialName = section.getString("material");
        if (materialName == null) {
            return null;
        }
        Material material = Material.getMaterial((String)materialName.toUpperCase());
        if (material == null) {
            return null;
        }
        int amount = section.getInt("amount", 1);
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ConfigurationSection enchantmentsSection;
            if (section.contains("name")) {
                meta.setDisplayName(section.getString("name"));
            }
            if (section.contains("lore")) {
                meta.setLore(section.getStringList("lore"));
            }
            if ((enchantmentsSection = section.getConfigurationSection("enchantments")) != null) {
                for (String enchantName : enchantmentsSection.getKeys(false)) {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantName.toLowerCase()));
                    if (enchantment == null) continue;
                    int level = enchantmentsSection.getInt(enchantName);
                    meta.addEnchant(enchantment, level, true);
                }
            }
            if (section.contains("customModelData")) {
                meta.setCustomModelData(Integer.valueOf(section.getInt("customModelData")));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public void saveRecipes() {
        try {
            this.recipesConfig.save(this.recipesFile);
        }
        catch (IOException e) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Failed to save recipes: " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
        }
    }

    public CustomRecipe findMatchingRecipe(ItemStack[] matrix) {
        for (CustomRecipe recipe : this.customRecipes.values()) {
            if (!recipe.matches(matrix)) continue;
            return recipe;
        }
        return null;
    }

    public void addRecipe(CustomRecipe recipe) {
        this.removeRecipe(recipe.getId());
        this.customRecipes.put(recipe.getId(), recipe);
        this.saveRecipeToConfig(recipe);
        this.saveRecipes();
        this.registerRecipeWithBukkit(recipe);
        this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Recipe registered with server: " + recipe.getId())).color(TextColor.color((int)65280))));
    }

    public void removeRecipe(String id) {
        this.removeRecipeFromBukkit(id);
        this.customRecipes.remove(id);
        this.recipesConfig.set("recipes." + id, null);
        this.saveRecipes();
    }

    public CustomRecipe getRecipe(String id) {
        return this.customRecipes.get(id);
    }

    public Collection<CustomRecipe> getAllRecipes() {
        return this.customRecipes.values();
    }

    private void saveRecipeToConfig(CustomRecipe recipe) {
        ConfigurationSection recipeSection = this.recipesConfig.createSection("recipes." + recipe.getId());
        recipeSection.set("name", (Object)recipe.getName());
        recipeSection.set("type", (Object)recipe.getType().name());
        recipeSection.set("exactMatch", (Object)recipe.isExactMatch());
        recipeSection.set("preserveNBT", (Object)recipe.isPreserveNBT());
        this.saveItemToConfig(recipeSection.createSection("result"), recipe.getResult());
        if (recipe.getType() == CustomRecipe.RecipeType.SHAPED) {
            recipeSection.set("shape", recipe.getShape());
            ConfigurationSection ingredientsSection = recipeSection.createSection("ingredients");
            for (Map.Entry<Character, ItemStack> entry : recipe.getIngredients().entrySet()) {
                this.saveItemToConfig(ingredientsSection.createSection(entry.getKey().toString()), entry.getValue());
            }
        } else {
            ConfigurationSection ingredientsSection = recipeSection.createSection("ingredients");
            for (int i = 0; i < recipe.getShapelessIngredients().size(); ++i) {
                this.saveItemToConfig(ingredientsSection.createSection(String.valueOf(i)), recipe.getShapelessIngredients().get(i));
            }
        }
    }

    private void saveItemToConfig(ConfigurationSection section, ItemStack item) {
        section.set("material", (Object)item.getType().name());
        section.set("amount", (Object)item.getAmount());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasDisplayName()) {
                section.set("name", (Object)meta.getDisplayName());
            }
            if (meta.hasLore()) {
                section.set("lore", (Object)meta.getLore());
            }
            if (meta.hasEnchants()) {
                ConfigurationSection enchantmentsSection = section.createSection("enchantments");
                for (Map.Entry entry : meta.getEnchants().entrySet()) {
                    enchantmentsSection.set(((Enchantment)entry.getKey()).getKey().getKey(), entry.getValue());
                }
            }
            if (meta.hasCustomModelData()) {
                section.set("customModelData", (Object)meta.getCustomModelData());
            }
        }
    }

    private void registerRecipeWithBukkit(CustomRecipe recipe) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipe.getId());
        this.removeRecipeFromBukkit(recipe.getId());
        ShapedRecipe bukkitRecipe = null;
        if (recipe.getType() == CustomRecipe.RecipeType.SHAPED) {
            ShapedRecipe shapedRecipe = new ShapedRecipe(key, recipe.getResult());
            List<String> shape = recipe.getShape();
            if (shape != null && !shape.isEmpty()) {
                String[] shapeArray = shape.toArray(new String[0]);
                shapedRecipe.shape(shapeArray);
                Map<Character, ItemStack> ingredients = recipe.getIngredients();
                if (ingredients != null) {
                    for (Map.Entry<Character, ItemStack> entry : ingredients.entrySet()) {
                        shapedRecipe.setIngredient(entry.getKey().charValue(), entry.getValue().getType());
                    }
                }
            }
            bukkitRecipe = shapedRecipe;
        } else {
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(key, recipe.getResult());
            List<ItemStack> ingredients = recipe.getShapelessIngredients();
            if (ingredients != null) {
                for (ItemStack ingredient : ingredients) {
                    shapelessRecipe.addIngredient(ingredient.getAmount(), ingredient.getType());
                }
            }
            bukkitRecipe = shapelessRecipe;
        }
        if (bukkitRecipe != null) {
            try {
                this.plugin.getServer().addRecipe((Recipe)bukkitRecipe);
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Successfully registered recipe with Bukkit: " + recipe.getId())).color(TextColor.color((int)65280))));
            }
            catch (Exception e) {
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Failed to register recipe with Bukkit: " + recipe.getId() + " - " + e.getMessage())).color(TextColor.color((int)0xFF0000))));
            }
        }
    }

    private void removeRecipeFromBukkit(String id) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        Iterator iterator = this.plugin.getServer().recipeIterator();
        while (iterator.hasNext()) {
            ShapelessRecipe shapeless;
            ShapedRecipe shaped;
            Recipe recipe = (Recipe)iterator.next();
            if (recipe instanceof ShapedRecipe && (shaped = (ShapedRecipe)recipe).getKey().equals((Object)key)) {
                iterator.remove();
                this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Removed existing recipe from server: " + id)).color(TextColor.color((int)0xFFFF00))));
                return;
            }
            if (!(recipe instanceof ShapelessRecipe) || !(shapeless = (ShapelessRecipe)recipe).getKey().equals((Object)key)) continue;
            iterator.remove();
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.getPrefix().append(Component.text((String)("Removed existing recipe from server: " + id)).color(TextColor.color((int)0xFFFF00))));
            return;
        }
    }
}

