/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.bloodred.customcrafty.CustomCraftyPlugin;
import me.bloodred.customcrafty.managers.RecipeManager;
import me.bloodred.customcrafty.models.CustomRecipe;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomCraftyCommand
implements CommandExecutor,
TabCompleter {
    private final RecipeManager recipeManager;
    private final CustomCraftyPlugin plugin;
    private static final Component PLUGIN_NAME_FORMATTED = ((TextComponent)Component.text((String)"CustomCrafty").color(TextColor.color((int)9849600))).decorate(TextDecoration.BOLD);
    private static final Component SEPARATOR = Component.text((String)"---------------------------------").color(TextColor.color((int)0x252525));

    public CustomCraftyCommand(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
        this.plugin = CustomCraftyPlugin.getInstance();
    }

    private void sendFormattedResponse(CommandSender sender, String title, List<Component> contentLines, NamedTextColor titleColor) {
        sender.sendMessage(SEPARATOR);
        Component commandPrefix = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)0x252525))).append(PLUGIN_NAME_FORMATTED)).append(Component.text((String)"] ").color(TextColor.color((int)0x252525)))).append(Component.text((String)("(v" + this.plugin.getDescription().getVersion() + ")")).color(TextColor.color((int)0x252525)));
        sender.sendMessage(commandPrefix);
        sender.sendMessage(SEPARATOR);
        if (title != null && !title.isEmpty()) {
            Component titleComponent = ((TextComponent)Component.text((String)title).color((TextColor)titleColor)).decorate(TextDecoration.BOLD);
            sender.sendMessage(titleComponent);
            sender.sendMessage(SEPARATOR);
        }
        for (Component line : contentLines) {
            sender.sendMessage(line);
        }
        sender.sendMessage(SEPARATOR);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("customcrafty.admin")) {
            sender.sendMessage(this.plugin.getPrefix().append(Component.text((String)"You don't have permission to use this command!").color(TextColor.color((int)0xFF0000))));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "create": {
                if (args.length < 2) {
                    List<Component> errorLines = Arrays.asList(Component.text((String)"Usage: /cc create <name>").color((TextColor)NamedTextColor.RED));
                    this.sendFormattedResponse(sender, "Error", errorLines, NamedTextColor.RED);
                    return true;
                }
                this.handleCreate(sender, args[1]);
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    List<Component> errorLines = Arrays.asList(Component.text((String)"Usage: /cc remove <name>").color((TextColor)NamedTextColor.RED));
                    this.sendFormattedResponse(sender, "Error", errorLines, NamedTextColor.RED);
                    return true;
                }
                this.handleRemove(sender, args[1]);
                break;
            }
            default: {
                List<Component> invalidLines = Arrays.asList(Component.text((String)"Unknown command. Use /cc help for available commands.").color((TextColor)NamedTextColor.RED));
                this.sendFormattedResponse(sender, "Error", invalidLines, NamedTextColor.RED);
            }
        }
        return true;
    }

    public void sendHelp(CommandSender sender) {
        List<Component> helpLines = Arrays.asList(((TextComponent)((TextComponent)Component.text((String)"/cc reload").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - ").color(TextColor.color((int)0x252525)))).append(Component.text((String)"Reload the plugin configuration").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/cc list").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - ").color(TextColor.color((int)0x252525)))).append(Component.text((String)"List all custom recipes").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/cc create <name>").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - ").color(TextColor.color((int)0x252525)))).append(Component.text((String)"Create a new recipe (hold item)").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/cc remove <name>").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - ").color(TextColor.color((int)0x252525)))).append(Component.text((String)"Remove an existing recipe").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/cc help").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" - ").color(TextColor.color((int)0x252525)))).append(Component.text((String)"Show this help message").color((TextColor)NamedTextColor.GRAY)));
        this.sendFormattedResponse(sender, "Command Help", helpLines, NamedTextColor.AQUA);
    }

    public void handleReload(CommandSender sender) {
        this.plugin.reloadConfig();
        this.recipeManager.loadRecipes();
        List<Component> lines = Arrays.asList(Component.text((String)"CustomCrafty configuration reloaded successfully!").color((TextColor)NamedTextColor.GREEN));
        this.sendFormattedResponse(sender, "Reload", lines, NamedTextColor.GREEN);
    }

    public void handleList(CommandSender sender) {
        if (this.recipeManager.getAllRecipes().isEmpty()) {
            List<Component> emptyLines = Arrays.asList(Component.text((String)"No custom recipes found.").color((TextColor)NamedTextColor.YELLOW), ((TextComponent)((TextComponent)Component.text((String)"Use ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"/cc create <name>").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" to create your first recipe.").color((TextColor)NamedTextColor.GRAY)));
            this.sendFormattedResponse(sender, "Recipe List", emptyLines, NamedTextColor.YELLOW);
            return;
        }
        ArrayList<Component> recipeLines = new ArrayList<Component>();
        recipeLines.add(((TextComponent)Component.text((String)"Total recipes: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)this.recipeManager.getAllRecipes().size()).color((TextColor)NamedTextColor.WHITE)));
        recipeLines.add((Component)Component.text((String)""));
        for (CustomRecipe recipe : this.recipeManager.getAllRecipes()) {
            String type = recipe.getType().name().toLowerCase();
            Component recipeLine = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2022 ").color(TextColor.color((int)0x252525))).append(Component.text((String)recipe.getId()).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" (").color(TextColor.color((int)0x252525)))).append(Component.text((String)type).color((TextColor)NamedTextColor.BLUE))).append(Component.text((String)")").color(TextColor.color((int)0x252525)));
            if (!recipe.getName().equals(recipe.getId())) {
                recipeLine = recipeLine.append(Component.text((String)" - ").color(TextColor.color((int)0x252525))).append(Component.text((String)recipe.getName()).color((TextColor)NamedTextColor.GRAY));
            }
            recipeLines.add(recipeLine);
        }
        this.sendFormattedResponse(sender, "Recipe List", recipeLines, NamedTextColor.YELLOW);
    }

    public void handleCreate(CommandSender sender, String recipeName) {
        if (!(sender instanceof Player)) {
            List<Component> errorLines = Arrays.asList(Component.text((String)"Only players can create recipes!").color((TextColor)NamedTextColor.RED));
            this.sendFormattedResponse(sender, "Error", errorLines, NamedTextColor.RED);
            return;
        }
        Player player = (Player)sender;
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem.getType().isAir()) {
            List<Component> errorLines = Arrays.asList(Component.text((String)"You must hold an item to create a recipe!").color((TextColor)NamedTextColor.RED), Component.text((String)"Hold the result item in your main hand and try again.").color((TextColor)NamedTextColor.GRAY));
            this.sendFormattedResponse(sender, "Error", errorLines, NamedTextColor.RED);
            return;
        }
        if (this.recipeManager.getRecipe(recipeName) != null) {
            List<Component> errorLines = Arrays.asList(Component.text((String)"A recipe with that name already exists!").color((TextColor)NamedTextColor.RED), Component.text((String)"Choose a different name or remove the existing recipe first.").color((TextColor)NamedTextColor.GRAY));
            this.sendFormattedResponse(sender, "Error", errorLines, NamedTextColor.RED);
            return;
        }
        CustomRecipe recipe = new CustomRecipe(recipeName, recipeName, CustomRecipe.RecipeType.SHAPELESS, heldItem.clone());
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ingredients.add(new ItemStack(heldItem.getType(), 1));
        recipe.setShapelessIngredients(ingredients);
        this.recipeManager.addRecipe(recipe);
        List<Component> successLines = Arrays.asList(((TextComponent)((TextComponent)Component.text((String)"Recipe '").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)recipeName).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"' created successfully!").color((TextColor)NamedTextColor.GREEN)), ((TextComponent)Component.text((String)"Result: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)heldItem.getType().name()).color((TextColor)NamedTextColor.WHITE)), Component.text((String)"Edit recipes.yml for advanced configurations.").color((TextColor)NamedTextColor.YELLOW));
        this.sendFormattedResponse(sender, "Recipe Created", successLines, NamedTextColor.GREEN);
    }

    public void handleRemove(CommandSender sender, String recipeName) {
        if (this.recipeManager.getRecipe(recipeName) == null) {
            List<Component> errorLines = Arrays.asList(((TextComponent)((TextComponent)Component.text((String)"Recipe '").color((TextColor)NamedTextColor.RED)).append(Component.text((String)recipeName).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"' not found!").color((TextColor)NamedTextColor.RED)), ((TextComponent)((TextComponent)Component.text((String)"Use ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"/cc list").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)" to see available recipes.").color((TextColor)NamedTextColor.GRAY)));
            this.sendFormattedResponse(sender, "Error", errorLines, NamedTextColor.RED);
            return;
        }
        this.recipeManager.removeRecipe(recipeName);
        List<Component> successLines = Arrays.asList(((TextComponent)((TextComponent)Component.text((String)"Recipe '").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)recipeName).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"' removed successfully!").color((TextColor)NamedTextColor.GREEN)));
        this.sendFormattedResponse(sender, "Recipe Removed", successLines, NamedTextColor.GREEN);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block4: {
            block3: {
                completions = new ArrayList<String>();
                if (!sender.hasPermission("customcrafty.admin")) {
                    return completions;
                }
                if (args.length != 1) break block3;
                String partial = args[0].toLowerCase();
                List<String> subCommands = Arrays.asList("help", "reload", "list", "create", "remove");
                for (String subCommand : subCommands) {
                    if (!subCommand.startsWith(partial)) continue;
                    completions.add(subCommand);
                }
                break block4;
            }
            if (args.length != 2 || !args[0].equalsIgnoreCase("remove")) break block4;
            String partial = args[1].toLowerCase();
            for (CustomRecipe recipe : this.recipeManager.getAllRecipes()) {
                if (!recipe.getId().toLowerCase().startsWith(partial)) continue;
                completions.add(recipe.getId());
            }
        }
        return completions;
    }
}

