/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.models;

import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class CustomRecipe {
    private String id;
    private String name;
    private RecipeType type;
    private ItemStack result;
    private Map<Character, ItemStack> ingredients;
    private List<String> shape;
    private List<ItemStack> shapelessIngredients;
    private boolean exactMatch;
    private boolean preserveNBT;

    public CustomRecipe(String id, String name, RecipeType type, ItemStack result) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.result = result;
        this.exactMatch = false;
        this.preserveNBT = true;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public RecipeType getType() {
        return this.type;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public Map<Character, ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(Map<Character, ItemStack> ingredients) {
        this.ingredients = ingredients;
    }

    public List<String> getShape() {
        return this.shape;
    }

    public void setShape(List<String> shape) {
        this.shape = shape;
    }

    public List<ItemStack> getShapelessIngredients() {
        return this.shapelessIngredients;
    }

    public void setShapelessIngredients(List<ItemStack> shapelessIngredients) {
        this.shapelessIngredients = shapelessIngredients;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    public boolean isPreserveNBT() {
        return this.preserveNBT;
    }

    public void setPreserveNBT(boolean preserveNBT) {
        this.preserveNBT = preserveNBT;
    }

    public boolean matches(ItemStack[] matrix) {
        if (this.type == RecipeType.SHAPED) {
            return this.matchesShaped(matrix);
        }
        return this.matchesShapeless(matrix);
    }

    private boolean matchesShaped(ItemStack[] matrix) {
        if (this.shape == null || this.ingredients == null) {
            return false;
        }
        int shapeRow = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                ItemStack expectedItem;
                int index = row * 3 + col;
                ItemStack item = matrix[index];
                char expectedChar = ' ';
                if (shapeRow < this.shape.size() && col < this.shape.get(shapeRow).length()) {
                    expectedChar = this.shape.get(shapeRow).charAt(col);
                }
                if (this.itemsMatch(item, expectedItem = this.ingredients.get(Character.valueOf(expectedChar)))) continue;
                return false;
            }
            if (shapeRow >= this.shape.size()) continue;
            ++shapeRow;
        }
        return true;
    }

    private boolean matchesShapeless(ItemStack[] matrix) {
        if (this.shapelessIngredients == null) {
            return false;
        }
        int totalItems = 0;
        for (ItemStack item : matrix) {
            if (item == null) continue;
            ++totalItems;
        }
        if (totalItems != this.shapelessIngredients.size()) {
            return false;
        }
        for (ItemStack required : this.shapelessIngredients) {
            boolean found = false;
            for (ItemStack item : matrix) {
                if (!this.itemsMatch(item, required)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean itemsMatch(ItemStack item1, ItemStack item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        if (this.exactMatch) {
            return item1.isSimilar(item2) && item1.getAmount() >= item2.getAmount();
        }
        return item1.getType() == item2.getType() && item1.getAmount() >= item2.getAmount();
    }

    public static enum RecipeType {
        SHAPED,
        SHAPELESS;

    }
}

