/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.customcrafty.utils;

import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SchedulerUtil {
    private static final boolean IS_FOLIA = SchedulerUtil.isFolia();

    private static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void scheduleTask(Plugin plugin, final Runnable task, boolean async) {
        if (IS_FOLIA) {
            if (async) {
                plugin.getServer().getAsyncScheduler().runNow(plugin, scheduledTask -> task.run());
            } else {
                plugin.getServer().getGlobalRegionScheduler().run(plugin, scheduledTask -> task.run());
            }
        } else if (async) {
            new BukkitRunnable(){

                public void run() {
                    task.run();
                }
            }.runTaskAsynchronously(plugin);
        } else {
            new BukkitRunnable(){

                public void run() {
                    task.run();
                }
            }.runTask(plugin);
        }
    }

    public static void scheduleDelayedTask(Plugin plugin, final Runnable task, long delay, boolean async) {
        if (IS_FOLIA) {
            if (async) {
                plugin.getServer().getAsyncScheduler().runDelayed(plugin, scheduledTask -> task.run(), delay * 50L, TimeUnit.MILLISECONDS);
            } else {
                plugin.getServer().getGlobalRegionScheduler().runDelayed(plugin, scheduledTask -> task.run(), delay);
            }
        } else if (async) {
            new BukkitRunnable(){

                public void run() {
                    task.run();
                }
            }.runTaskLaterAsynchronously(plugin, delay);
        } else {
            new BukkitRunnable(){

                public void run() {
                    task.run();
                }
            }.runTaskLater(plugin, delay);
        }
    }
}

