/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals;

import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.core.Config;
import com.almostreliable.summoningrituals.core.Registration;
import com.almostreliable.summoningrituals.data.DataGeneration;
import com.almostreliable.summoningrituals.network.PacketHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import org.slf4j.Logger;

@Mod(value="summoningrituals")
public final class SummoningRituals {
    public static final Logger LOGGER = LogUtils.getLogger();

    public SummoningRituals(IEventBus eventBus, ModContainer modContainer) {
        Registration.init(eventBus);
        PacketHandler.init(eventBus);
        Config.init(modContainer);
        eventBus.addListener(DataGeneration::init);
        NeoForge.EVENT_BUS.addListener(SummoningRituals::onEntityDeathLoot);
    }

    public static ResourceLocation getRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"summoningrituals", (String)key);
    }

    private static void onEntityDeathLoot(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (entity.getTags().contains(AltarBlockEntity.SACRIFICE_TAG)) {
            BlockPos pos = entity.blockPosition();
            RandomSource rand = level2.random;
            level2.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + rand.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + rand.nextDouble(), 6, 0.0, 0.0, 0.0, 0.05);
            event.setCanceled(true);
        }
    }
}

