/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar;

import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.altar.base.TickableEntityBlock;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AltarBlock
extends TickableEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Stream.of(AltarBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), AltarBlock.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), AltarBlock.box((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final Map<Direction, Vector3f[]> CANDLE_POSITIONS = AltarBlock.initCandlePositions();

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING}).add(new Property[]{ACTIVE}).add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState superState = super.getStateForPlacement(context);
        BlockState state = superState == null ? this.defaultBlockState() : superState;
        return (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState nState, LevelAccessor level, BlockPos pos, BlockPos nPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, nState, level, pos, nPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AltarBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AltarBlockEntity)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        AltarBlockEntity altar = (AltarBlockEntity)blockEntity;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND) {
                if (stack.isEmpty()) {
                    if (player.isShiftKeyDown()) {
                        altar.removeLastInsertedItem();
                    }
                    return ItemInteractionResult.CONSUME;
                }
                if (!player.isShiftKeyDown()) {
                    ItemStack remainder = altar.handleItemInsertion(serverPlayer, stack, false);
                    serverPlayer.setItemInHand(InteractionHand.MAIN_HAND, remainder);
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof AltarBlockEntity) {
                AltarBlockEntity altar = (AltarBlockEntity)blockEntity;
                altar.getInventory().dropContents(serverLevel, pos);
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Boolean active = (Boolean)state.getValue((Property)ACTIVE);
        Vector3f[] candlePositions = CANDLE_POSITIONS.get(facing);
        BlockPos posAbove = pos.above();
        for (int i = 0; i < 3; ++i) {
            this.renderCandleParticles(level, posAbove, candlePositions[i], (ParticleOptions)(active != false ? ParticleTypes.SOUL : ParticleTypes.SMALL_FLAME), active != false ? 3 : 0);
        }
    }

    private void renderCandleParticles(Level level, BlockPos pos, Vector3f candlePosition, ParticleOptions particleType, int yOffset) {
        level.addParticle(particleType, (double)((float)pos.getX() + candlePosition.x() / 16.0f), (double)((float)pos.getY() + (candlePosition.y() + (float)yOffset) / 16.0f), (double)((float)pos.getZ() + candlePosition.z() / 16.0f), 0.0, 0.0, 0.0);
    }

    private static Map<Direction, Vector3f[]> initCandlePositions() {
        EnumMap<Direction, Vector3f[]> candlePositions = new EnumMap<Direction, Vector3f[]>(Direction.class);
        Vector3f[] northPositions = new Vector3f[]{new Vector3f(3.5f, 1.5f, 9.5f), new Vector3f(9.5f, 3.5f, 12.5f), new Vector3f(11.5f, 4.5f, 10.5f)};
        candlePositions.put(Direction.NORTH, northPositions);
        candlePositions.put(Direction.SOUTH, new Vector3f[]{AltarBlock.opposite(northPositions[0]), AltarBlock.opposite(northPositions[1]), AltarBlock.opposite(northPositions[2])});
        candlePositions.put(Direction.EAST, new Vector3f[]{AltarBlock.neighbor(northPositions[0]), AltarBlock.neighbor(northPositions[1]), AltarBlock.neighbor(northPositions[2])});
        candlePositions.put(Direction.WEST, new Vector3f[]{AltarBlock.opposite(AltarBlock.neighbor(northPositions[0])), AltarBlock.opposite(AltarBlock.neighbor(northPositions[1])), AltarBlock.opposite(AltarBlock.neighbor(northPositions[2]))});
        return candlePositions;
    }

    private static Vector3f opposite(Vector3f v) {
        return new Vector3f(16.0f - v.x(), v.y(), 16.0f - v.z());
    }

    private static Vector3f neighbor(Vector3f v) {
        Vector3f o = AltarBlock.opposite(v);
        return new Vector3f(o.z(), v.y(), v.x());
    }
}

