/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar;

import com.almostreliable.summoningrituals.SummoningRituals;
import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.altar.base.TickableBlockEntity;
import com.almostreliable.summoningrituals.altar.inventory.AltarInventory;
import com.almostreliable.summoningrituals.altar.inventory.AltarInventoryHost;
import com.almostreliable.summoningrituals.compat.AltarObservable;
import com.almostreliable.summoningrituals.core.Registration;
import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.network.AltarInventorySyncPacket;
import com.almostreliable.summoningrituals.network.AltarRecipeSyncPacket;
import com.almostreliable.summoningrituals.network.PacketHandler;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.RecipeInfoContainer;
import com.almostreliable.summoningrituals.recipe.RecipeMatchResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AltarBlockEntity
extends BlockEntity
implements TickableBlockEntity,
AltarInventoryHost {
    public static final AltarObservable SUMMONING_START = new AltarObservable();
    public static final AltarObservable SUMMONING_COMPLETE = new AltarObservable();
    public static final String SACRIFICE_TAG = SummoningRituals.getRL("marker").toString();
    public static final LootContextParamSet LOOT_CONTEXT_PARAM_SET = new LootContextParamSet.Builder().required(LootContextParams.BLOCK_STATE).required(LootContextParams.BLOCK_ENTITY).required(LootContextParams.ORIGIN).build();
    private final AltarInventory inventory = new AltarInventory(this);
    @Nullable
    private RecipeInfoContainer currentRecipeInfo;
    @Nullable
    private ServerPlayer invokingPlayer;
    private int recipeProgress;
    private int recipeTime;

    public AltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.ALTAR_BLOCK_ENTITY.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registryAccess) {
        super.saveAdditional(tag, registryAccess);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registryAccess));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registryAccess) {
        super.loadAdditional(tag, registryAccess);
        if (tag.contains("inventory")) {
            this.inventory.deserializeNBT(registryAccess, tag.getCompound("inventory"));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryAccess) {
        return this.inventory.serializeWithoutInsertOrder(registryAccess);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registryAccess) {
        this.inventory.deserializeNBT(registryAccess, tag);
    }

    @Override
    public void tick(ServerLevel level) {
        if (this.currentRecipeInfo == null) {
            return;
        }
        if (this.recipeProgress >= this.recipeTime) {
            AltarRecipe recipe = this.currentRecipeInfo.recipe();
            if (this.inventory.consumeRecipeInputs(level, recipe)) {
                recipe.invokeCommands(level, this.invokingPlayer);
                Collection<ItemEntity> itemOutputs = recipe.spawnOutputs(level, this.worldPosition, recipe.itemOutputs());
                Collection<Entity> entityOutputs = recipe.spawnOutputs(level, this.worldPosition, recipe.entityOutputs());
                RecipeInfoContainer recipeInfo = RecipeInfoContainer.outputInfo(this.currentRecipeInfo, itemOutputs, entityOutputs);
                SUMMONING_COMPLETE.invoke(level, this.worldPosition, recipeInfo, this.invokingPlayer);
                this.playOptionalPlayerSound(level, this.invokingPlayer, false, SoundEvents.EXPERIENCE_ORB_PICKUP);
            } else {
                this.sendOptionalPlayerMessage(this.invokingPlayer, false, SummoningLang.MISSING_INPUTS, ChatFormatting.RED);
            }
            this.reset(level);
            return;
        }
        if (this.recipeProgress == 0) {
            this.changeActivityState(true, level);
        }
        ++this.recipeProgress;
        this.sendAltarRecipeSyncUpdate(level);
    }

    @Override
    public void onInventoryChanged(Function<HolderLookup.Provider, CompoundTag> serializer) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.setChanged();
        CompoundTag inventoryTag = serializer.apply((HolderLookup.Provider)serverLevel.registryAccess());
        PacketHandler.sendToTrackingChunk(serverLevel, this.worldPosition, new AltarInventorySyncPacket(this.worldPosition, inventoryTag));
    }

    public void removeLastInsertedItem() {
        this.inventory.removeLastInsertedItem();
    }

    @Override
    public void spawnItemAboveAltar(ItemStack stack) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemEntity itemEntity = new ItemEntity(this.level, 0.0, 0.0, 0.0, stack);
        Vec3 pos = Vec3.atCenterOf((Vec3i)this.worldPosition.above());
        itemEntity.setPos(pos);
        serverLevel.addFreshEntity((Entity)itemEntity);
    }

    @Override
    public ItemStack handleItemInsertion(@Nullable ServerPlayer player, ItemStack stack, boolean simulate) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return stack;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.currentRecipeInfo != null) {
            this.sendOptionalPlayerMessage(player, simulate, SummoningLang.IN_PROGRESS, ChatFormatting.RED);
            return stack;
        }
        RecipeMatchResult matchResult = null;
        if (AltarRecipe.isInitiator(serverLevel.getRecipeManager(), stack.getItem()) && (matchResult = this.handleInitiatorInsertion(serverLevel, player, stack, simulate)).getInteractionRemainder() != null) {
            return matchResult.getInteractionRemainder();
        }
        if (AltarRecipe.isInput(serverLevel.getRecipeManager(), stack.getItem())) {
            return this.handleInputInsertion(serverLevel, player, stack, simulate);
        }
        if (!simulate && matchResult != null && matchResult.hasIssue()) {
            this.playOptionalPlayerSound(serverLevel, player, false, SoundEvents.CHAIN_BREAK);
            this.sendOptionalPlayerMessage(player, false, matchResult.getMatchIssue().getIssueMessage(), ChatFormatting.RED);
        }
        return stack;
    }

    private RecipeMatchResult handleInitiatorInsertion(ServerLevel level, @Nullable ServerPlayer player, ItemStack stack, boolean simulate) {
        ItemStack remainder;
        RecipeMatchResult matchResult = this.getMatchingRecipes(level, player, stack);
        if (matchResult.hasIssue()) {
            return matchResult;
        }
        if (!simulate) {
            this.inventory.setInitiator(stack.copyWithCount(1));
        }
        remainder = (remainder = stack.copyWithCount(stack.getCount() - 1)).isEmpty() ? ItemStack.EMPTY : remainder;
        matchResult.setInteractionRemainder(remainder);
        if (simulate) {
            return matchResult;
        }
        RecipeInfoContainer recipeInfo = matchResult.getMatchingRecipe();
        if (!SUMMONING_START.invoke(level, this.worldPosition, recipeInfo, player)) {
            this.reset(level);
            this.removeLastInsertedItem();
            return matchResult;
        }
        for (Entity entityInput : recipeInfo.inputEntities()) {
            entityInput.addTag(SACRIFICE_TAG);
            entityInput.kill();
        }
        this.currentRecipeInfo = recipeInfo;
        this.invokingPlayer = player;
        this.recipeTime = recipeInfo.recipe().ticks();
        this.playOptionalPlayerSound(level, player, false, SoundEvents.BEACON_ACTIVATE);
        this.sendAltarRecipeSyncUpdate(level);
        return matchResult;
    }

    private ItemStack handleInputInsertion(ServerLevel level, @Nullable ServerPlayer player, ItemStack stack, boolean simulate) {
        ItemStack remaining = this.inventory.insertInputTracked(stack, simulate);
        if (remaining.isEmpty() || stack.getCount() != remaining.getCount()) {
            this.playOptionalPlayerSound(level, player, simulate, SoundEvents.ITEM_PICKUP);
        }
        return remaining;
    }

    private RecipeMatchResult getMatchingRecipes(ServerLevel level, @Nullable ServerPlayer player, ItemStack stack) {
        List recipeHolders = level.getRecipeManager().getRecipesFor((RecipeType)Registration.ALTAR_RECIPE_TYPE.get(), (RecipeInput)this.inventory, (Level)level);
        recipeHolders.removeIf(h -> !((AltarRecipe)h.value()).initiator().test(stack));
        if (recipeHolders.isEmpty()) {
            return RecipeMatchResult.INVALID_INITIATOR;
        }
        HashSet<RecipeInfoContainer> matchingRecipes = new HashSet<RecipeInfoContainer>();
        for (RecipeHolder recipeHolder : recipeHolders) {
            AltarRecipe recipe = (AltarRecipe)recipeHolder.value();
            List<Entity> entityInputs = recipe.getSacrifices(this.worldPosition, region -> level.getEntities((Entity)player, region));
            if (entityInputs == null) continue;
            matchingRecipes.add(RecipeInfoContainer.inputInfo((RecipeHolder<AltarRecipe>)recipeHolder, entityInputs));
        }
        if (matchingRecipes.isEmpty()) {
            return RecipeMatchResult.MISSING_SACRIFICES;
        }
        LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.BLOCK_STATE, (Object)this.getBlockState()).withParameter(LootContextParams.BLOCK_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).create(LOOT_CONTEXT_PARAM_SET);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        matchingRecipes.removeIf(recipeInfo -> {
            AltarRecipe recipe = recipeInfo.recipe();
            return !recipe.startConditions().stream().allMatch(condition -> condition.test((Object)lootContext));
        });
        if (matchingRecipes.isEmpty()) {
            return RecipeMatchResult.FAILED_CONDITIONS;
        }
        if (matchingRecipes.size() > 1) {
            return RecipeMatchResult.MULTI_MATCH;
        }
        return RecipeMatchResult.of(matchingRecipes);
    }

    private void sendOptionalPlayerMessage(@Nullable ServerPlayer player, boolean simulate, SummoningLang.LangEntry langEntry, ChatFormatting color) {
        if (player == null || simulate) {
            return;
        }
        player.sendSystemMessage((Component)langEntry.get().withStyle(color));
    }

    private void playOptionalPlayerSound(ServerLevel level, @Nullable ServerPlayer player, boolean simulate, SoundEvent sound) {
        if (player == null || simulate) {
            return;
        }
        level.playSound(null, this.worldPosition, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private void reset(ServerLevel level) {
        this.currentRecipeInfo = null;
        this.invokingPlayer = null;
        this.recipeProgress = 0;
        this.recipeTime = 0;
        this.changeActivityState(false, level);
        this.sendAltarRecipeSyncUpdate(level);
    }

    private void sendAltarRecipeSyncUpdate(ServerLevel level) {
        PacketHandler.sendToTrackingChunk(level, this.worldPosition, new AltarRecipeSyncPacket(this.worldPosition, this.recipeProgress, this.recipeTime));
    }

    private void changeActivityState(boolean state, ServerLevel level) {
        BlockState oldState = level.getBlockState(this.worldPosition);
        if (!((Boolean)oldState.getValue((Property)AltarBlock.ACTIVE)).equals(state)) {
            level.setBlockAndUpdate(this.worldPosition, (BlockState)oldState.setValue((Property)AltarBlock.ACTIVE, (Comparable)Boolean.valueOf(state)));
        }
    }

    @Nullable
    public IItemHandler getCapability(@Nullable Direction ignoredSide) {
        if (!this.remove && this.recipeProgress == 0) {
            return this.inventory;
        }
        return null;
    }

    @Override
    @Nullable
    public RecipeManager getRecipeManager() {
        if (this.level == null) {
            return null;
        }
        return this.level.getRecipeManager();
    }

    public AltarInventory getInventory() {
        return this.inventory;
    }

    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRecipeProgress(int recipeProgress) {
        this.recipeProgress = recipeProgress;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRecipeTime(int recipeTime) {
        this.recipeTime = recipeTime;
    }
}

