/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar.inventory;

import com.almostreliable.summoningrituals.altar.inventory.AltarInventoryHost;
import com.almostreliable.summoningrituals.altar.inventory.InternalInventory;
import com.almostreliable.summoningrituals.core.Config;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.UnknownNullability;

public class AltarInventory
implements IItemHandlerModifiable,
RecipeInput,
INBTSerializable<CompoundTag> {
    private final AltarInventoryHost host;
    private final InternalInventory inventory;
    private final Stack<Tuple<ItemStack, Integer>> insertOrder;
    private ItemStack initiator;

    public AltarInventory(AltarInventoryHost host) {
        this.host = host;
        this.inventory = new InternalInventory((Integer)Config.COMMON.inventorySize.get());
        this.insertOrder = new Stack();
        this.initiator = ItemStack.EMPTY;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider registryAccess) {
        CompoundTag compoundTag = this.serializeWithoutInsertOrder(registryAccess);
        ListTag insertOrderTag = new ListTag();
        for (Tuple tuple : this.insertOrder) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putInt("slot", ((Integer)tuple.getB()).intValue());
            Tag finishedEntryTag = ((ItemStack)tuple.getA()).save(registryAccess, (Tag)entryTag);
            insertOrderTag.add((Object)finishedEntryTag);
        }
        compoundTag.put("insert_order", (Tag)insertOrderTag);
        return compoundTag;
    }

    public CompoundTag serializeWithoutInsertOrder(HolderLookup.Provider registryAccess) {
        CompoundTag inventoryTag = this.inventory.serializeNBT(registryAccess);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("inventory", (Tag)inventoryTag);
        compoundTag.put("initiator", this.initiator.saveOptional(registryAccess));
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider registryAccess, CompoundTag tag) {
        CompoundTag inventoryTag = tag.getCompound("inventory");
        this.inventory.deserializeNBT(registryAccess, inventoryTag);
        if (tag.contains("insert_order")) {
            ListTag insertOrderTag = tag.getList("insert_order", 10);
            this.insertOrder.clear();
            for (int i = 0; i < insertOrderTag.size(); ++i) {
                CompoundTag entryTag = insertOrderTag.getCompound(i);
                int slot = entryTag.getInt("slot");
                ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)entryTag).ifPresent(stack -> this.insertOrder.add((Tuple<ItemStack, Integer>)new Tuple(stack, (Object)slot)));
            }
        }
        CompoundTag initiatorTag = tag.getCompound("initiator");
        this.initiator = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)initiatorTag);
    }

    public int getSlots() {
        return this.inventory.slots() + 1;
    }

    public int getSlotLimit(int slot) {
        if (slot == this.getInitiatorSlot()) {
            return 1;
        }
        return 64;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == this.getInitiatorSlot()) {
            return this.initiator;
        }
        return this.inventory.get(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot == this.getInitiatorSlot()) {
            Preconditions.checkArgument((stack.getCount() == 1 ? 1 : 0) != 0, (Object)"initiator must be a single item");
            this.initiator = stack;
        } else {
            this.inventory.set(slot, stack);
        }
        this.onContentsChanged();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        RecipeManager recipeManager = this.host.getRecipeManager();
        if (recipeManager == null) {
            return false;
        }
        if (slot == this.getInitiatorSlot()) {
            return AltarRecipe.isInitiator(recipeManager, stack.getItem());
        }
        return AltarRecipe.isInput(recipeManager, stack.getItem());
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.host.handleItemInsertion(null, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public ItemStack getItem(int index) {
        return this.getStackInSlot(index);
    }

    public int size() {
        return this.getSlots();
    }

    public ItemStack insertInputTracked(ItemStack inputStack, boolean simulate) {
        int remainingCount = inputStack.getCount();
        for (int slot = 0; slot < this.inventory.slots(); ++slot) {
            ItemStack stackToInsert = inputStack.copyWithCount(remainingCount);
            if ((remainingCount = this.insertOrFillItemInSlot(slot, stackToInsert, simulate)) == 0) {
                this.trackInsert(slot, stackToInsert.copy(), simulate);
                return ItemStack.EMPTY;
            }
            if (remainingCount == stackToInsert.getCount()) continue;
            int insertedCount = stackToInsert.getCount() - remainingCount;
            this.trackInsert(slot, stackToInsert.copyWithCount(insertedCount), simulate);
        }
        if (remainingCount == 0) {
            return ItemStack.EMPTY;
        }
        return inputStack.copyWithCount(remainingCount);
    }

    private int insertOrFillItemInSlot(int slot, ItemStack stack, boolean simulate) {
        ItemStack stackInSlot = this.inventory.get(slot);
        if (stackInSlot.isEmpty()) {
            if (!simulate) {
                this.setStackInSlot(slot, stack);
            }
            return 0;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
            return stack.getCount();
        }
        int maxCount = Math.min(this.getSlotLimit(slot), stackInSlot.getMaxStackSize());
        int toInsert = Math.min(maxCount - stackInSlot.getCount(), stack.getCount());
        if (toInsert <= 0) {
            return stack.getCount();
        }
        if (!simulate) {
            stackInSlot.grow(toInsert);
            this.onContentsChanged();
        }
        return stack.getCount() - toInsert;
    }

    private void trackInsert(int slot, ItemStack stack, boolean simulate) {
        if (simulate) {
            return;
        }
        this.insertOrder.push((Tuple<ItemStack, Integer>)new Tuple((Object)stack, (Object)slot));
    }

    public void removeLastInsertedItem() {
        if (!this.initiator.isEmpty()) {
            this.host.spawnItemAboveAltar(this.initiator);
            this.initiator = ItemStack.EMPTY;
            this.onContentsChanged();
            return;
        }
        if (this.insertOrder.isEmpty()) {
            return;
        }
        Tuple<ItemStack, Integer> last = this.insertOrder.pop();
        ItemStack stack = (ItemStack)last.getA();
        int slot = (Integer)last.getB();
        this.inventory.get(slot).shrink(stack.getCount());
        if (this.inventory.get(slot).isEmpty()) {
            this.inventory.remove(slot);
        }
        this.onContentsChanged();
        this.host.spawnItemAboveAltar(stack);
    }

    public boolean consumeRecipeInputs(ServerLevel level, AltarRecipe recipe) {
        CompoundTag snapshot = this.inventory.serializeNBT((HolderLookup.Provider)level.registryAccess());
        int toRemoveTotal = 0;
        int removedTotal = 0;
        for (SizedIngredient input : recipe.itemInputs()) {
            toRemoveTotal += input.count();
            int alreadyRemoved = 0;
            for (int slot = 0; slot < this.inventory.slots(); ++slot) {
                ItemStack stack = this.inventory.get(slot);
                if (stack.isEmpty() || !input.ingredient().test(stack)) continue;
                int shrinkCount = Math.min(input.count() - alreadyRemoved, stack.getCount());
                stack.shrink(shrinkCount);
                if (stack.isEmpty()) {
                    this.inventory.remove(slot);
                }
                if ((alreadyRemoved += shrinkCount) >= input.count()) break;
            }
            removedTotal += alreadyRemoved;
        }
        if (removedTotal < toRemoveTotal) {
            this.inventory.deserializeNBT((HolderLookup.Provider)level.registryAccess(), snapshot);
            return false;
        }
        this.initiator = ItemStack.EMPTY;
        this.rebuildInsertOrder();
        this.onContentsChanged();
        return true;
    }

    public void dropContents(ServerLevel serverLevel, BlockPos blockPos) {
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            this.dropItem(serverLevel, stack, blockPos);
        }
        this.inventory.clear();
        this.insertOrder.clear();
        if (!this.initiator.isEmpty()) {
            this.dropItem(serverLevel, this.initiator, blockPos);
            this.initiator = ItemStack.EMPTY;
        }
        this.onContentsChanged();
    }

    private void dropItem(ServerLevel level, ItemStack stack, BlockPos blockPos) {
        ItemEntity itemEntity = new ItemEntity((Level)level, 0.0, 0.0, 0.0, stack);
        itemEntity.setPos(Vec3.atCenterOf((Vec3i)blockPos));
        level.addFreshEntity((Entity)itemEntity);
    }

    private void onContentsChanged() {
        this.host.onInventoryChanged(this::serializeWithoutInsertOrder);
    }

    private void rebuildInsertOrder() {
        this.insertOrder.clear();
        for (int slot = this.inventory.slots(); slot >= 0; --slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            this.trackInsert(slot, stack.copy(), false);
        }
    }

    private int getInitiatorSlot() {
        return this.inventory.slots();
    }

    public ItemStack getInitiator() {
        return this.initiator;
    }

    public void setInitiator(ItemStack initiator) {
        this.initiator = initiator;
        this.onContentsChanged();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ItemStack> getDisplayItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            items.add(stack);
        }
        return items;
    }
}

