/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar.inventory;

import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

final class InternalInventory
implements INBTSerializable<CompoundTag>,
Iterable<ItemStack> {
    private ItemStack[] items;

    InternalInventory(int size) {
        this.items = new ItemStack[size];
        this.clear();
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    void set(int slot, ItemStack stack) {
        this.items[slot] = stack;
    }

    ItemStack get(int slot) {
        return this.items[slot];
    }

    void remove(int slot) {
        this.items[slot] = ItemStack.EMPTY;
    }

    void clear() {
        Arrays.fill(this.items, ItemStack.EMPTY);
    }

    int slots() {
        return this.items.length;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag itemsListTag = new ListTag();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("slot", i);
            Tag finishedItemTag = this.items[i].save(provider, (Tag)itemTag);
            itemsListTag.add((Object)finishedItemTag);
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("size", this.items.length);
        compoundTag.put("items", (Tag)itemsListTag);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        int size = tag.getInt("size");
        ListTag itemsListTag = tag.getList("items", 10);
        this.items = new ItemStack[size];
        this.clear();
        for (int i = 0; i < itemsListTag.size(); ++i) {
            CompoundTag itemTag = itemsListTag.getCompound(i);
            int slot = itemTag.getInt("slot");
            ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTag).ifPresent(stack -> {
                this.items[slot] = stack;
            });
        }
    }
}

