/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.client;

import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.core.Config;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AltarRenderer
implements BlockEntityRenderer<AltarBlockEntity> {
    private static final float HALF = 0.5f;
    private static final float HALF_CIRCLE = 180.0f;
    private static final float FULL_CIRCLE = 360.0f;
    private static final float ALTAR_RENDER_HEIGHT = 0.8f;
    private static final int MAX_ITEM_HEIGHT = 2;
    private static final int MAX_RESET = 60;
    private static final float MAX_PROGRESS_HEIGHT = 2.5f;
    private static final float ITEM_OFFSET = 1.5f;
    private final ItemRenderer itemRenderer;
    private final int altarRenderDistance;
    private float resetTimer;
    private float oldCircleOffset;

    public AltarRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.altarRenderDistance = (Integer)Config.CLIENT.renderDistance.get();
    }

    public void render(AltarBlockEntity altar, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = altar.getLevel();
        if (player == null || level == null || !altar.getBlockPos().closerThan((Vec3i)player.blockPosition(), (double)this.altarRenderDistance)) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5f, 0.8f, 0.5f);
        stack.summoning$scale(0.5f);
        this.renderInventoryContents(stack, buffer, altar, (Player)player, level, partialTick, packedOverlay);
        stack.popPose();
    }

    private void renderInventoryContents(PoseStack stack, MultiBufferSource buffer, AltarBlockEntity altar, Player player, Level level, float partialTick, int packedOverlay) {
        BlockPos altarPos = altar.getBlockPos();
        Vec3 altarCenterPos = Vec3.atCenterOf((Vec3i)altarPos);
        Vec3 playerPos = player.position();
        float playerToAltarDistance = (float)altarCenterPos.distanceTo(playerPos);
        double playerToAltarRatio = Math.atan2(altarCenterPos.x - playerPos.x, playerPos.z - altarCenterPos.z);
        float playerToAltarAngle = (float)(Math.toDegrees(playerToAltarRatio) + 180.0);
        float recipeProgress = altar.getRecipeProgress();
        float recipeTime = altar.getRecipeTime();
        float recipeProgressRatio = AltarRenderer.ratio(recipeProgress, recipeTime, 0.0f);
        int lightAbove = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)altarPos.above());
        RenderContext renderContext = new RenderContext(altar, level, stack, buffer, lightAbove, packedOverlay, partialTick, playerToAltarAngle, recipeProgressRatio);
        stack.translate(0.0f, 2.5f * recipeProgressRatio, 0.0f);
        this.renderInitiator(renderContext);
        this.renderItemOrbit(renderContext, recipeProgress, recipeTime, playerToAltarDistance);
        if (recipeTime > 0.0f && recipeProgress >= recipeTime) {
            this.resetTimer = 60.0f;
        }
    }

    private void renderInitiator(RenderContext renderContext) {
        ItemStack initiator = renderContext.altar.getInventory().getInitiator();
        if (initiator.isEmpty()) {
            return;
        }
        PoseStack stack = renderContext.stack;
        stack.pushPose();
        stack.translate(0.0f, AltarRenderer.invert(0.75f * renderContext.recipeProgressRatio), 0.0f);
        stack.summoning$scale(0.75f);
        stack.mulPose(Axis.YN.rotationDegrees(renderContext.playerToAltarAngle));
        renderContext.renderStatic(this.itemRenderer, initiator);
        stack.popPose();
    }

    private void renderItemOrbit(RenderContext renderContext, float recipeProgress, float recipeTime, float playerToAltarDistance) {
        List<ItemStack> inputs = renderContext.altar.getInventory().getDisplayItems();
        if (inputs.isEmpty()) {
            return;
        }
        float axisRotation = AltarRenderer.clampRotation(renderContext.level.getGameTime());
        float scale = AltarRenderer.invert(renderContext.recipeProgressRatio);
        if (recipeProgress == 0.0f && this.resetTimer > 0.0f) {
            scale = AltarRenderer.invert(AltarRenderer.ratio(this.resetTimer, 60.0f, 0.0f));
            this.resetTimer = Math.max(0.0f, this.resetTimer - renderContext.partialTick);
        }
        PoseStack stack = renderContext.stack;
        stack.summoning$scale(scale);
        for (int i = 0; i < inputs.size(); ++i) {
            float circleOffset;
            stack.pushPose();
            float itemRotation = 360.0f - (float)i * 360.0f / (float)inputs.size();
            if (recipeProgress > 0.0f) {
                circleOffset = AltarRenderer.ratio(recipeProgress, recipeTime, 1.0f) * 360.0f * 3.0f + this.oldCircleOffset;
            } else {
                this.oldCircleOffset = circleOffset = renderContext.playerToAltarAngle;
            }
            float rotationDiff = AltarRenderer.clampRotation(axisRotation + itemRotation - circleOffset);
            if (rotationDiff > 180.0f) {
                rotationDiff = 360.0f - rotationDiff;
            }
            float newHeight = rotationDiff / 180.0f * 2.0f;
            float playerOffset = Math.max(1.0f - playerToAltarDistance / 8.0f, 0.0f);
            stack.mulPose(Axis.YN.rotationDegrees(AltarRenderer.clampRotation(itemRotation + axisRotation)));
            stack.translate(0.0f, newHeight *= playerOffset, -1.5f);
            renderContext.renderStatic(this.itemRenderer, inputs.get(i));
            stack.popPose();
        }
    }

    private static float clampRotation(float degree) {
        return Math.abs(degree) % 360.0f;
    }

    private static float invert(float value) {
        return 1.0f - value;
    }

    private static float ratio(float current, float max, float fallback) {
        return max == 0.0f ? fallback : current / max;
    }

    private record RenderContext(AltarBlockEntity altar, Level level, PoseStack stack, MultiBufferSource buffer, int lightAbove, int packedOverlay, float partialTick, float playerToAltarAngle, float recipeProgressRatio) {
        private void renderStatic(ItemRenderer itemRenderer, ItemStack item) {
            itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, this.lightAbove, this.packedOverlay, this.stack, this.buffer, this.level, 0);
        }
    }
}

