/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public class MeasuringBufferSource
implements MultiBufferSource {
    private final MeasuringVertexConsumer instance = new MeasuringVertexConsumer();

    public VertexConsumer getBuffer(RenderType renderType) {
        return this.instance;
    }

    @Nullable
    public MeasuringResult getData() {
        return this.instance.data;
    }

    private static final class MeasuringVertexConsumer
    implements VertexConsumer {
        @Nullable
        private MeasuringResult data;

        private MeasuringVertexConsumer() {
        }

        private void record(float x, float y, float z) {
            this.data = this.data == null ? new MeasuringResult(x, y, z) : this.data.measure(x, y, z);
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            this.record(x, y, z);
            return this;
        }

        public VertexConsumer setColor(int r, int g, int b, int a) {
            return this;
        }

        public VertexConsumer setUv(float u, float v) {
            return this;
        }

        public VertexConsumer setUv1(int u, int v) {
            return this;
        }

        public VertexConsumer setUv2(int u, int v) {
            return this;
        }

        public VertexConsumer setOverlay(int overlay) {
            return this;
        }

        public VertexConsumer setNormal(float nx, float ny, float nz) {
            return this;
        }
    }

    public record MeasuringResult(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        public static final MeasuringResult EMPTY = new MeasuringResult(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);

        MeasuringResult(float x, float y, float z) {
            this(x, y, z, x, y, z);
        }

        MeasuringResult measure(float x, float y, float z) {
            float mMinX = Math.min(this.minX, x);
            float mMinY = Math.min(this.minY, y);
            float mMinZ = Math.min(this.minZ, z);
            float mMaxX = Math.max(this.maxX, x);
            float mMaxY = Math.max(this.maxY, y);
            float mMaxZ = Math.max(this.maxZ, z);
            return new MeasuringResult(mMinX, mMinY, mMinZ, mMaxX, mMaxY, mMaxZ);
        }
    }
}

