/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.kubejs.builder;

import com.almostreliable.summoningrituals.recipe.condition.TimeCondition;
import com.almostreliable.summoningrituals.recipe.condition.WeatherCondition;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.Nullable;

public final class ConditionsBuilder {
    private final SourceLine sourceLine;
    private final List<LootItemCondition> conditions = new ArrayList<LootItemCondition>();
    @Nullable
    private LocationPredicate.Builder locationPredicate;

    @HideFromJS
    public ConditionsBuilder(SourceLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ConditionsBuilder biomes(HolderSet<Biome> biomes) {
        this.getOrCreateLocationPredicate().setBiomes(biomes);
        return this;
    }

    public ConditionsBuilder dimension(ResourceKey<Level> dimension) {
        this.getOrCreateLocationPredicate().setDimension(dimension);
        return this;
    }

    public ConditionsBuilder minHeight(int min) {
        this.getOrCreateLocationPredicate().setY(MinMaxBounds.Doubles.atLeast((double)min));
        return this;
    }

    public ConditionsBuilder maxHeight(int max) {
        this.getOrCreateLocationPredicate().setY(MinMaxBounds.Doubles.atMost((double)max));
        return this;
    }

    public ConditionsBuilder height(int height) {
        this.getOrCreateLocationPredicate().setY(MinMaxBounds.Doubles.exactly((double)height));
        return this;
    }

    public ConditionsBuilder height(int min, int max) {
        this.getOrCreateLocationPredicate().setY(MinMaxBounds.Doubles.between((double)min, (double)max));
        return this;
    }

    public ConditionsBuilder setOpenSky(boolean openSky) {
        this.getOrCreateLocationPredicate().setCanSeeSky(openSky);
        return this;
    }

    public ConditionsBuilder structures(HolderSet<Structure> structures) {
        this.getOrCreateLocationPredicate().setStructures(structures);
        return this;
    }

    public ConditionsBuilder minTime(int min) {
        this.conditions.add((LootItemCondition)new TimeCheck(Optional.of(24000L), IntRange.lowerBound((int)min)));
        return this;
    }

    public ConditionsBuilder maxTime(int max) {
        this.conditions.add((LootItemCondition)new TimeCheck(Optional.of(24000L), IntRange.upperBound((int)max)));
        return this;
    }

    public ConditionsBuilder time(int min, int max) {
        this.conditions.add((LootItemCondition)new TimeCheck(Optional.of(24000L), IntRange.range((int)min, (int)max)));
        return this;
    }

    public ConditionsBuilder time(TimeCondition.TimeType timeType) {
        this.conditions.add((LootItemCondition)new TimeCheck(Optional.of(24000L), timeType.range));
        return this;
    }

    public ConditionsBuilder weather(Function<WeatherCondition.Builder, WeatherCondition.Builder> weather) {
        try {
            WeatherCondition.Builder builder = new WeatherCondition.Builder();
            WeatherCheck weatherCheck = weather.apply(builder).build();
            this.conditions.add((LootItemCondition)weatherCheck);
        }
        catch (IllegalArgumentException e) {
            this.throwException(e.getMessage());
        }
        return this;
    }

    @HideFromJS
    public List<LootItemCondition> build() {
        List<String> duplicates;
        if (this.locationPredicate != null) {
            this.conditions.add(LocationCheck.checkLocation((LocationPredicate.Builder)this.locationPredicate).build());
        }
        if (!(duplicates = this.conditions.stream().collect(Collectors.groupingBy(LootItemCondition::getClass, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).map(Class::getSimpleName).toList()).isEmpty()) {
            this.throwException("only one condition of each type allowed, duplicates found: " + String.valueOf(duplicates));
        }
        return this.conditions;
    }

    private LocationPredicate.Builder getOrCreateLocationPredicate() {
        if (this.locationPredicate == null) {
            this.locationPredicate = LocationPredicate.Builder.location();
        }
        return this.locationPredicate;
    }

    private void throwException(String message) throws KubeRuntimeException {
        throw new KubeRuntimeException(message).source(this.sourceLine);
    }
}

