/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.common;

import com.almostreliable.summoningrituals.compat.kubejs.builder.SummoningEntityBuilder;
import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class EntityIngredient {
    public static final Codec<EntityIngredient> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.ENTITY_TYPE.holderByNameCodec().fieldOf("id").forGetter(e -> e.entityInfo.entity())).apply((Applicative)i, e -> new EntityIngredient(new SummoningEntityBuilder((Holder<EntityType<?>>)e).build())));
    private final EntityInfo entityInfo;
    @Nullable
    private Entity entity;

    public EntityIngredient(EntityInfo entityInfo) {
        this.entityInfo = entityInfo;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            this.entity = ((EntityType)entityInfo.entity().value()).create((Level)level);
            if (this.entity != null && entityInfo.data().isPresent()) {
                this.entity.load(entityInfo.data().get());
            }
        }
    }

    public Component getDisplayName() {
        if (this.entity == null) {
            return Component.literal((String)"Unknown Entity");
        }
        return this.entity.getDisplayName();
    }

    public List<Component> getTooltip(boolean customTooltip, boolean advanced) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (this.entity == null) {
            return tooltip;
        }
        tooltip.add(this.getDisplayName());
        List<Component> entityTooltip = this.entityInfo.tooltip();
        if (customTooltip && !entityTooltip.isEmpty()) {
            tooltip.addAll(entityTooltip);
        }
        if (advanced) {
            MutableComponent id = Component.literal((String)this.getId().toString());
            tooltip.add((Component)id.withStyle(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public ResourceLocation getId() {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)this.entityInfo.entity().value()));
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Nullable
    public ItemStack getEgg() {
        SpawnEggItem item = SpawnEggItem.byId((EntityType)((EntityType)this.entityInfo.entity().value()));
        return item == null ? null : new ItemStack((ItemLike)item);
    }

    public EntityIngredient copy() {
        return new EntityIngredient(this.entityInfo);
    }
}

