/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.common;

import com.almostreliable.summoningrituals.SummoningRituals;
import com.almostreliable.summoningrituals.client.MeasuringBufferSource;
import com.almostreliable.summoningrituals.compat.viewer.common.EntityIngredient;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import org.joml.Vector3f;

public final class EntityIngredientRenderer {
    private static final Map<ResourceLocation, MeasuringBufferSource.MeasuringResult> MEASURING_RESULT_CACHE = new HashMap<ResourceLocation, MeasuringBufferSource.MeasuringResult>();
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int MEASURE_TICKS = 40;
    private static final int HALF_ROT = 180;

    private EntityIngredientRenderer() {
    }

    public static void render(GuiGraphics guiGraphics, EntityIngredient entityIngredient, boolean scissor, boolean count) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null || !((entity = entityIngredient.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        MeasuringBufferSource.MeasuringResult measuringResult = EntityIngredientRenderer.measureEntity(mc, entity2, entityIngredient.getId());
        if (measuringResult == MeasuringBufferSource.MeasuringResult.EMPTY) {
            return;
        }
        entity2.tickCount = mc.player.tickCount;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        EntityIngredientRenderer.renderEntity(mc, guiGraphics, entity2, measuringResult, scissor);
        poseStack.popPose();
        int entityCount = entityIngredient.getEntityInfo().count();
        if (!count || entityCount <= 1) {
            return;
        }
        poseStack.pushPose();
        EntityIngredientRenderer.renderCount(mc, guiGraphics, entityCount);
        poseStack.popPose();
    }

    private static MeasuringBufferSource.MeasuringResult measureEntity(Minecraft mc, LivingEntity entity, ResourceLocation entityId) {
        MeasuringBufferSource.MeasuringResult cached = MEASURING_RESULT_CACHE.get(entityId);
        if (cached != null) {
            return cached;
        }
        EntityRenderDispatcher entityRenderer = mc.getEntityRenderDispatcher();
        MeasuringBufferSource measuringBuffer = new MeasuringBufferSource();
        PoseStack poseStack = new PoseStack();
        int i = 0;
        while (i < 40) {
            int ticks = i++;
            RenderSystem.runAsFancy(() -> entityRenderer.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, (float)ticks, poseStack, (MultiBufferSource)measuringBuffer, 0xF000F0));
        }
        MeasuringBufferSource.MeasuringResult measuringResult = measuringBuffer.getData();
        if (measuringResult == null) {
            SummoningRituals.LOGGER.error("failed to measure entity: {}", (Object)entityId);
            return MeasuringBufferSource.MeasuringResult.EMPTY;
        }
        MEASURING_RESULT_CACHE.put(entityId, measuringResult);
        return measuringResult;
    }

    private static void renderEntity(Minecraft mc, GuiGraphics guiGraphics, LivingEntity entity, MeasuringBufferSource.MeasuringResult measuringResult, boolean scissor) {
        PoseStack poseStack = guiGraphics.pose();
        if (scissor) {
            Vector3f absolutePos = poseStack.last().pose().transformPosition(0.0f, 0.0f, 0.0f, new Vector3f());
            int absX = (int)absolutePos.x;
            int absY = (int)absolutePos.y;
            guiGraphics.enableScissor(absX, absY, absX + 16, absY + 16);
        }
        poseStack.translate(8.0f, 16.0f, 100.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderer = mc.getEntityRenderDispatcher();
        entityRenderer.setRenderShadow(false);
        RenderSystem.enableBlend();
        entity.absRotateTo(180.0f, 0.0f);
        entity.yBodyRotO = 180.0f;
        entity.yBodyRot = 180.0f;
        entity.yHeadRotO = 180.0f;
        entity.yHeadRot = 180.0f;
        if (entity instanceof WitherBoss) {
            WitherBoss witherBoss = (WitherBoss)entity;
            float[] yRotHeads = witherBoss.yRotHeads;
            float[] yRotOHeads = witherBoss.yRotOHeads;
            for (int i = 0; i < yRotHeads.length; ++i) {
                yRotHeads[i] = 180.0f;
                yRotOHeads[i] = 180.0f;
            }
        }
        float width = measuringResult.maxX() - measuringResult.minX();
        float height = measuringResult.maxY() - measuringResult.minY();
        float heightScale = 16.0f / height;
        float widthScale = 16.0f / width * 2.0f;
        float scale = Math.min(widthScale, heightScale);
        poseStack.translate(0.0f, -measuringResult.minY() * heightScale, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(20.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(5.0f));
        poseStack.scale(scale, scale, -scale);
        RenderSystem.runAsFancy(() -> entityRenderer.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0));
        guiGraphics.flush();
        entityRenderer.setRenderShadow(true);
        Lighting.setupFor3DItems();
        if (scissor) {
            guiGraphics.disableScissor();
        }
    }

    private static void renderCount(Minecraft mc, GuiGraphics guiGraphics, int count) {
        guiGraphics.pose().translate(10.0f, 9.0f, 200.0f);
        guiGraphics.drawString(mc.font, String.valueOf(count), 0, 0, 0xFFFFFF, true);
    }
}

