/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.common;

import com.almostreliable.summoningrituals.SummoningRituals;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.almostreliable.summoningrituals.recipe.output.EntityOutput;
import com.almostreliable.summoningrituals.recipe.output.ItemOutput;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class RecipeViewerAltarLayout {
    public static final int SLOT_SIZE = 16;
    protected static final ResourceLocation TEXTURE = SummoningRituals.getRL(String.format("textures/gui/%s.png", "recipe_viewer"));
    protected static final int TEXTURE_WIDTH = 172;
    protected static final int TEXTURE_HEIGHT = 148;
    protected static final int CENTER_X = 86;
    protected static final int CENTER_Y = 74;
    private static final int INPUT_RADIUS = 46;

    public int getWidth() {
        return 172;
    }

    public int getHeight() {
        return 148;
    }

    protected void createInitiatorSlot(SlotConsumer slotConsumer) {
        int x = 78;
        int y = 32;
        slotConsumer.accept(x, y, 0);
    }

    protected void createInputSlots(AltarRecipe recipe, SlotConsumer slotConsumer) {
        List<SizedIngredient> itemInputs = recipe.itemInputs();
        List<EntityInfo> entityInputs = recipe.entityInputs();
        int inputSlots = itemInputs.size() + entityInputs.size();
        for (int i = 0; i < inputSlots; ++i) {
            int x = 86 + (int)(Math.cos((double)(i * 2) * Math.PI / (double)inputSlots) * 46.0) - 8;
            int y = 64 + (int)(Math.sin((double)(i * 2) * Math.PI / (double)inputSlots) * 46.0) - 8;
            slotConsumer.accept(x, y, i);
        }
    }

    protected void createOutputSlots(AltarRecipe recipe, SlotConsumer slotConsumer) {
        List<ItemOutput> itemOutputs = recipe.itemOutputs();
        List<EntityOutput> entityOutputs = recipe.entityOutputs();
        int outputSlots = itemOutputs.size() + entityOutputs.size();
        for (int i = 0; i < outputSlots; ++i) {
            int x = 2 + i * 16;
            int y = 130;
            slotConsumer.accept(x, y, i);
        }
    }

    @FunctionalInterface
    public static interface SlotConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

