/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.emi;

import com.almostreliable.summoningrituals.compat.viewer.common.EntityIngredient;
import com.almostreliable.summoningrituals.compat.viewer.common.RecipeViewerAltarLayout;
import com.almostreliable.summoningrituals.compat.viewer.emi.EmiPlugin;
import com.almostreliable.summoningrituals.compat.viewer.emi.entity.EntityEmiStack;
import com.almostreliable.summoningrituals.compat.viewer.emi.widget.InitiatorSlotWidget;
import com.almostreliable.summoningrituals.compat.viewer.emi.widget.InvisibleSlotWidget;
import com.almostreliable.summoningrituals.compat.viewer.emi.widget.StackWidget;
import com.almostreliable.summoningrituals.core.Registration;
import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.almostreliable.summoningrituals.recipe.condition.ConditionRegistry;
import com.almostreliable.summoningrituals.recipe.output.EntityOutput;
import com.almostreliable.summoningrituals.recipe.output.ItemOutput;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class AltarEmiRecipe
extends RecipeViewerAltarLayout
implements EmiRecipe {
    private final RecipeHolder<AltarRecipe> recipeHolder;

    AltarEmiRecipe(RecipeHolder<AltarRecipe> recipeHolder) {
        this.recipeHolder = recipeHolder;
    }

    public EmiRecipeCategory getCategory() {
        return EmiPlugin.ALTAR_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipeHolder.id();
    }

    public List<EmiIngredient> getInputs() {
        AltarRecipe recipe = (AltarRecipe)this.recipeHolder.value();
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        for (SizedIngredient itemInput : recipe.itemInputs()) {
            inputs.add(EmiIngredient.of((Ingredient)itemInput.ingredient(), (long)itemInput.count()));
        }
        for (EntityInfo entityInput : recipe.entityInputs()) {
            EntityIngredient entityIngredient = new EntityIngredient(entityInput);
            inputs.add((EmiIngredient)EntityEmiStack.input(entityIngredient));
        }
        inputs.add(EmiIngredient.of((Ingredient)recipe.initiator()));
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        AltarRecipe recipe = (AltarRecipe)this.recipeHolder.value();
        List<ItemOutput> itemOutputs = recipe.itemOutputs();
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        for (ItemOutput itemOutput : itemOutputs) {
            outputs.add(EmiStack.of((ItemStack)itemOutput.item()));
        }
        for (EntityOutput entityOutput : recipe.entityOutputs()) {
            EntityIngredient entityIngredient = new EntityIngredient(entityOutput.entityInfo());
            outputs.add(EntityEmiStack.output(entityIngredient));
        }
        return outputs;
    }

    public List<EmiIngredient> getCatalysts() {
        ItemStack egg;
        EntityIngredient entityIngredient;
        AltarRecipe recipe = (AltarRecipe)this.recipeHolder.value();
        ArrayList<EmiIngredient> catalysts = new ArrayList<EmiIngredient>();
        for (EntityInfo entityInput : recipe.entityInputs()) {
            entityIngredient = new EntityIngredient(entityInput);
            egg = entityIngredient.getEgg();
            if (egg == null) continue;
            catalysts.add((EmiIngredient)EmiStack.of((ItemStack)egg));
        }
        for (EntityOutput entityOutput : recipe.entityOutputs()) {
            entityIngredient = new EntityIngredient(entityOutput.entityInfo());
            egg = entityIngredient.getEgg();
            if (egg == null) continue;
            catalysts.add((EmiIngredient)EmiStack.of((ItemStack)egg));
        }
        return catalysts;
    }

    public int getDisplayWidth() {
        return this.getWidth();
    }

    public int getDisplayHeight() {
        return this.getHeight();
    }

    public void addWidgets(WidgetHolder widgets) {
        StackWidget slot2;
        widgets.addTexture(TEXTURE, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 172, 148);
        widgets.add((Widget)new InvisibleSlotWidget((EmiIngredient)EmiStack.of(Registration.ALTAR_BLOCK), 78, 56));
        AltarRecipe recipe = (AltarRecipe)this.recipeHolder.value();
        this.createInitiatorSlot((x, y, slot) -> widgets.add((Widget)new InitiatorSlotWidget(EmiIngredient.of((Ingredient)recipe.initiator()), x, y)));
        List<EmiIngredient> inputs = this.getInputs();
        this.createInputSlots(recipe, (x, y, slot) -> widgets.add((Widget)new InvisibleSlotWidget((EmiIngredient)inputs.get(slot), x, y)));
        List<EmiStack> outputs = this.getOutputs();
        this.createOutputSlots(recipe, (x, y, slot) -> ((InvisibleSlotWidget)widgets.add((Widget)new InvisibleSlotWidget((EmiIngredient)outputs.get(slot), x, y))).recipeContext(this));
        if (!recipe.startConditions().isEmpty()) {
            slot2 = (StackWidget)widgets.add((Widget)new StackWidget((EmiIngredient)EmiStack.of((ItemLike)Items.NETHER_STAR), 2, 2));
            slot2.appendTooltip((Component)SummoningLang.CONDITIONS.get().append(":").withStyle(ChatFormatting.GOLD));
            for (LootItemCondition condition : recipe.startConditions()) {
                List<Component> conditionTooltips = ConditionRegistry.getTooltip(condition);
                for (Component conditionTooltip : conditionTooltips) {
                    slot2.appendTooltip(conditionTooltip);
                }
            }
        }
        if (recipe.commands().isPresent()) {
            slot2 = (StackWidget)widgets.add((Widget)new StackWidget((EmiIngredient)EmiStack.of((ItemLike)Items.COMMAND_BLOCK), 154, 111));
            slot2.appendTooltip((Component)SummoningLang.COMMANDS.get().append(":").withStyle(ChatFormatting.GOLD));
            for (Component commandTooltip : recipe.commands().get().getTooltip()) {
                slot2.appendTooltip(commandTooltip);
            }
        }
    }
}

