/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.emi.entity;

import com.almostreliable.summoningrituals.compat.viewer.common.EntityIngredient;
import com.almostreliable.summoningrituals.compat.viewer.common.EntityIngredientRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class EntityEmiStack
extends EmiStack {
    private final EntityIngredient entityIngredient;
    private final boolean scissor;

    private EntityEmiStack(EntityIngredient entityIngredient, boolean scissor) {
        this.entityIngredient = entityIngredient;
        this.scissor = scissor;
        this.amount = entityIngredient.getEntityInfo().count();
    }

    public static EntityEmiStack input(EntityIngredient entityIngredient) {
        return new EntityEmiStack(entityIngredient, false);
    }

    public static EntityEmiStack output(EntityIngredient entityIngredient) {
        return new EntityEmiStack(entityIngredient, true);
    }

    public EmiStack copy() {
        return new EntityEmiStack(this.entityIngredient.copy(), this.scissor);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float delta, int flags) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        EntityIngredientRenderer.render(guiGraphics, this.entityIngredient, flags == -1 && this.scissor, (flags & 2) != 0);
        poseStack.popPose();
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return this.entityIngredient.getEntityInfo().entity().value();
    }

    public ResourceLocation getId() {
        return this.entityIngredient.getId();
    }

    public List<Component> getTooltipText() {
        return List.of();
    }

    public List<ClientTooltipComponent> getTooltip() {
        Minecraft mc = Minecraft.getInstance();
        List<Component> tooltips = this.entityIngredient.getTooltip(true, mc.options.advancedItemTooltips);
        ArrayList<ClientTooltipComponent> res = new ArrayList<ClientTooltipComponent>();
        for (Component tooltip : tooltips) {
            res.add(EmiTooltipComponents.of((Component)tooltip));
        }
        EmiTooltipComponents.appendModName(res, (String)this.getId().getNamespace());
        return res;
    }

    public Component getName() {
        return this.entityIngredient.getDisplayName();
    }
}

