/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.jei;

import com.almostreliable.summoningrituals.compat.viewer.common.EntityIngredient;
import com.almostreliable.summoningrituals.compat.viewer.common.RecipeViewerAltarLayout;
import com.almostreliable.summoningrituals.compat.viewer.jei.JeiPlugin;
import com.almostreliable.summoningrituals.compat.viewer.jei.entity.EntityIngredientJeiRenderer;
import com.almostreliable.summoningrituals.core.Registration;
import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.almostreliable.summoningrituals.recipe.condition.ConditionRegistry;
import com.almostreliable.summoningrituals.recipe.output.CommandOutput;
import com.almostreliable.summoningrituals.recipe.output.EntityOutput;
import com.almostreliable.summoningrituals.recipe.output.ItemOutput;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class AltarJeiCategory
extends RecipeViewerAltarLayout
implements IRecipeCategory<RecipeHolder<AltarRecipe>> {
    static final RecipeType<RecipeHolder<AltarRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)Registration.ALTAR_RECIPE_TYPE.get()));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable conditionIcon;
    private final IDrawable commandsIcon;

    AltarJeiCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 172, 148).setTextureSize(172, 148).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Registration.ALTAR_BLOCK.toStack());
        this.conditionIcon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.NETHER_STAR.getDefaultInstance());
        this.commandsIcon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.COMMAND_BLOCK.getDefaultInstance());
    }

    public RecipeType<RecipeHolder<AltarRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return SummoningLang.ALTAR.get();
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RecipeHolder<AltarRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Optional<CommandOutput> recipeCommands;
        this.background.draw(guiGraphics);
        List<LootItemCondition> recipeConditions = ((AltarRecipe)recipeHolder.value()).startConditions();
        if (!recipeConditions.isEmpty()) {
            this.conditionIcon.draw(guiGraphics, 2, 2);
        }
        if ((recipeCommands = ((AltarRecipe)recipeHolder.value()).commands()).isPresent()) {
            this.commandsIcon.draw(guiGraphics, 154, 111);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<AltarRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        List<LootItemCondition> recipeConditions = ((AltarRecipe)recipeHolder.value()).startConditions();
        if (!recipeConditions.isEmpty() && AltarJeiCategory.mouseInSlot(mouseX, mouseY, 2, 2)) {
            tooltip.add((FormattedText)SummoningLang.CONDITIONS.get().append(":").withStyle(ChatFormatting.GOLD));
            for (LootItemCondition condition : recipeConditions) {
                tooltip.addAll(ConditionRegistry.getTooltip(condition));
            }
            return;
        }
        Optional<CommandOutput> recipeCommands = ((AltarRecipe)recipeHolder.value()).commands();
        if (recipeCommands.isPresent() && AltarJeiCategory.mouseInSlot(mouseX, mouseY, 154, 111)) {
            tooltip.add((FormattedText)SummoningLang.COMMANDS.get().append(":").withStyle(ChatFormatting.GOLD));
            tooltip.addAll(recipeCommands.get().getTooltip());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<AltarRecipe> recipeHolder, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 78, 56).addItemLike(Registration.ALTAR_BLOCK);
        AltarRecipe recipe = (AltarRecipe)recipeHolder.value();
        this.createInitiatorSlot((x, y, slot) -> ((IRecipeSlotBuilder)builder.addInputSlot(x, y).addIngredients(recipe.initiator())).addRichTooltipCallback(AltarJeiCategory::constructInitiatorTooltip));
        this.createInputSlots(recipe, (x, y, slot) -> {
            List<SizedIngredient> itemInputs = recipe.itemInputs();
            if (slot < itemInputs.size()) {
                SizedIngredient itemInput = itemInputs.get(slot);
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : itemInput.ingredient().getItems()) {
                    stack.setCount(itemInput.count());
                    itemStacks.add(stack);
                }
                builder.addInputSlot(x, y).addItemStacks(itemStacks);
            } else {
                EntityInfo entityInput = recipe.entityInputs().get(slot - itemInputs.size());
                EntityIngredient entityIngredient = new EntityIngredient(entityInput);
                ItemStack entityEgg = entityIngredient.getEgg();
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).setCustomRenderer(JeiPlugin.ENTITY_INGREDIENT, (IIngredientRenderer)EntityIngredientJeiRenderer.INPUT_RENDERER).addIngredient(JeiPlugin.ENTITY_INGREDIENT, (Object)entityIngredient);
                if (entityEgg == null) {
                    return;
                }
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(entityEgg);
            }
        });
        this.createOutputSlots(recipe, (x, y, slot) -> {
            List<ItemOutput> itemOutputs = recipe.itemOutputs();
            if (slot < itemOutputs.size()) {
                ItemStack stack = itemOutputs.get(slot).item();
                builder.addOutputSlot(x, y).addItemStack(stack);
            } else {
                List<EntityOutput> entityOutputs = recipe.entityOutputs();
                EntityInfo entityOutput = entityOutputs.get(slot - itemOutputs.size()).entityInfo();
                EntityIngredient entityIngredient = new EntityIngredient(entityOutput);
                ItemStack entityEgg = entityIngredient.getEgg();
                builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setCustomRenderer(JeiPlugin.ENTITY_INGREDIENT, (IIngredientRenderer)EntityIngredientJeiRenderer.OUTPUT_RENDERER).addIngredient(JeiPlugin.ENTITY_INGREDIENT, (Object)entityIngredient);
                if (entityEgg == null) {
                    return;
                }
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(entityEgg);
            }
        });
    }

    private static void constructInitiatorTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        List tooltipLines = tooltip.getLines();
        FormattedText stackTooltip = ((Either)tooltipLines.getFirst()).left().orElse(null);
        if (stackTooltip == null) {
            return;
        }
        MutableComponent initiatorComponent = SummoningLang.INITIATOR.get().append(": ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)stackTooltip.getString()).withStyle(ChatFormatting.WHITE));
        tooltipLines.removeFirst();
        tooltipLines.addFirst(Either.left((Object)SummoningLang.INSERT_LAST.get().withStyle(ChatFormatting.GRAY)));
        tooltipLines.addFirst(Either.left((Object)initiatorComponent));
    }

    private static boolean mouseInSlot(double mouseX, double mouseY, int x, int y) {
        return mouseX >= (double)x && mouseX <= (double)(x + 16) && mouseY >= (double)y && mouseY <= (double)(y + 16);
    }
}

