/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.core;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    private static final ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    private static final ModConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;

    private Config() {
    }

    public static void init(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair commonPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)commonPair.getRight();
        COMMON = (CommonConfig)commonPair.getLeft();
        Pair clientPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
    }

    public static final class CommonConfig {
        public final ModConfigSpec.IntValue inventorySize;
        public final ModConfigSpec.BooleanValue announceCommand;

        private CommonConfig(ModConfigSpec.Builder builder) {
            this.inventorySize = builder.comment("The number of slots in the Altar's inventory.").comment("To apply changes to existing Altars, you will need to break and replace them.").defineInRange("inventory_size", 16, 1, 64);
            this.announceCommand = builder.comment("Whether to announce in the log when a recipe output command is invoked.").comment("This is useful to avoid confusion where the command originates from.").define("announce_command", true);
        }
    }

    public static final class ClientConfig {
        public final ModConfigSpec.IntValue renderDistance;

        private ClientConfig(ModConfigSpec.Builder builder) {
            this.renderDistance = builder.comment("The maximum distance at which an Altar will render its inventory contents.").defineInRange("render_distance", 32, 1, 128);
        }
    }
}

