/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.core;

import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.AltarRecipeSerializer;
import com.almostreliable.summoningrituals.recipe.condition.ConditionRegistry;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class Registration {
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"summoningrituals");
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"summoningrituals");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"summoningrituals");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"summoningrituals");
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"summoningrituals");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"summoningrituals");
    public static final DeferredBlock<AltarBlock> ALTAR_BLOCK = Registration.registerBlock("altar", SummoningLang.ALTAR, AltarBlock::new, p -> p.strength(2.5f));
    public static final DeferredBlock<AltarBlock> INDESTRUCTIBLE_ALTAR_BLOCK = Registration.registerBlock("indestructible_altar", SummoningLang.INDESTRUCTIBLE_ALTAR, AltarBlock::new, p -> p.strength(-1.0f, 3600000.0f));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AltarBlockEntity>> ALTAR_BLOCK_ENTITY = Registration.registerBlockEntity(ALTAR_BLOCK.getId(), AltarBlockEntity::new, ALTAR_BLOCK, INDESTRUCTIBLE_ALTAR_BLOCK);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = CREATIVE_TABS.register("tab", () -> CreativeModeTab.builder().title((Component)SummoningLang.LangEntry.of("tab", "main", "Summoning Rituals").get()).icon(() -> ALTAR_BLOCK.toStack()).noScrollBar().displayItems((features, output) -> output.acceptAll(Registration.getKnownItems())).build());
    public static final DeferredHolder<RecipeType<?>, RecipeType<AltarRecipe>> ALTAR_RECIPE_TYPE = RECIPE_TYPES.register("altar", () -> new RecipeType<AltarRecipe>(){

        public String toString() {
            return "altar";
        }
    });
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<AltarRecipe>> ALTAR_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("altar", AltarRecipeSerializer::new);

    private Registration() {
    }

    public static void init(IEventBus eventBus) {
        CREATIVE_TABS.register(eventBus);
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        RECIPE_TYPES.register(eventBus);
        RECIPE_SERIALIZERS.register(eventBus);
        ConditionRegistry.init();
        eventBus.addListener(Registration::registerCapabilities);
    }

    private static Collection<ItemStack> getKnownItems() {
        return ITEMS.getEntries().stream().map(e -> ((Item)e.value()).getDefaultInstance()).toList();
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ALTAR_BLOCK_ENTITY.get(), AltarBlockEntity::getCapability);
    }

    private static <B extends Block> DeferredBlock<B> registerBlock(String id, SummoningLang.LangEntry langEntry, Function<BlockBehaviour.Properties, B> factory, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> propertiesConfigurator) {
        DeferredBlock block = BLOCKS.registerBlock(id, factory, propertiesConfigurator.apply(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).sound(SoundType.STONE)));
        ITEMS.registerSimpleBlockItem((Holder)block);
        SummoningLang.LangEntry.of("item", id, langEntry.get().getString());
        return block;
    }

    private static <E extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<E>> registerBlockEntity(ResourceLocation id, BlockEntityType.BlockEntitySupplier<E> factory, DeferredBlock<?> ... blocks) {
        return BLOCK_ENTITIES.register(id.getPath(), () -> {
            Block[] blockArray = new Block[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                blockArray[i] = (Block)blocks[i].get();
            }
            return BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])blockArray).build(null);
        });
    }
}

